/*
 * Decompiled with CFR 0.152.
 */
package com.hotels.styx.api;

import com.hotels.styx.api.HttpHeaderNames;
import com.hotels.styx.api.HttpHeaderValues;
import com.hotels.styx.api.HttpHeaders;
import com.hotels.styx.api.messages.HttpVersion;
import java.util.Optional;

public final class HttpMessageSupport {
    private HttpMessageSupport() {
    }

    public static boolean chunked(HttpHeaders headers) {
        for (String value : headers.getAll(HttpHeaderNames.TRANSFER_ENCODING)) {
            if (!value.equalsIgnoreCase(HttpHeaderNames.CHUNKED.toString())) continue;
            return true;
        }
        return false;
    }

    public static boolean keepAlive(HttpHeaders headers, io.netty.handler.codec.http.HttpVersion version) {
        Optional<String> connection = headers.get(HttpHeaderNames.CONNECTION);
        if (connection.isPresent()) {
            if (HttpHeaderValues.CLOSE.toString().equalsIgnoreCase(connection.get())) {
                return false;
            }
            if (HttpHeaderValues.KEEP_ALIVE.toString().equalsIgnoreCase(connection.get())) {
                return true;
            }
        }
        return version.isKeepAliveDefault();
    }

    public static boolean keepAlive(HttpHeaders headers, HttpVersion version) {
        Optional<String> connection = headers.get(HttpHeaderNames.CONNECTION);
        if (connection.isPresent()) {
            if (HttpHeaderValues.CLOSE.toString().equalsIgnoreCase(connection.get())) {
                return false;
            }
            if (HttpHeaderValues.KEEP_ALIVE.toString().equalsIgnoreCase(connection.get())) {
                return true;
            }
        }
        return version.isKeepAliveDefault();
    }
}

