/*
 * Decompiled with CFR 0.152.
 */
package com.hotels.styx.api;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.hotels.styx.api.FormData;
import com.hotels.styx.api.HttpCookie;
import com.hotels.styx.api.HttpCookieAttribute;
import com.hotels.styx.api.HttpHeaderNames;
import com.hotels.styx.api.HttpHeaderValues;
import com.hotels.styx.api.HttpHeaders;
import com.hotels.styx.api.HttpMessage;
import com.hotels.styx.api.HttpMessageBody;
import com.hotels.styx.api.HttpMessageBuilder;
import com.hotels.styx.api.HttpMessageSupport;
import com.hotels.styx.api.Url;
import com.hotels.styx.api.messages.FullHttpRequest;
import com.hotels.styx.api.support.CookiesSupport;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.handler.codec.http.DefaultHttpContent;
import io.netty.handler.codec.http.DefaultHttpRequest;
import io.netty.handler.codec.http.DefaultLastHttpContent;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.multipart.DefaultHttpDataFactory;
import io.netty.handler.codec.http.multipart.HttpDataFactory;
import io.netty.handler.codec.http.multipart.HttpPostRequestDecoder;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Function;
import rx.Observable;

public final class HttpRequest
implements HttpMessage {
    private final Object id;
    private final InetSocketAddress clientAddress;
    private final HttpVersion version;
    private final HttpMethod method;
    private final Url url;
    private final HttpHeaders headers;
    private final HttpMessageBody body;
    private final boolean secure;
    private final ImmutableList<HttpCookie> cookies;
    private volatile HttpPostRequestDecoder postRequestDecoder;

    private HttpRequest(Builder builder) {
        this.id = builder.id != null ? builder.id : UUID.randomUUID();
        this.clientAddress = builder.clientAddress;
        this.version = builder.version();
        this.method = builder.method;
        this.url = builder.url;
        this.secure = builder.secure;
        this.headers = builder.headers().build();
        this.body = builder.body();
        this.cookies = ImmutableList.copyOf((Collection)builder.cookies);
    }

    public Object id() {
        return this.id;
    }

    @Override
    public HttpVersion version() {
        return this.version;
    }

    public HttpMethod method() {
        return this.method;
    }

    public Url url() {
        return this.url;
    }

    public String path() {
        return this.url.path();
    }

    public boolean keepAlive() {
        return HttpMessageSupport.keepAlive(this.headers, this.version);
    }

    public Optional<String> header(CharSequence name) {
        return this.headers.get(name);
    }

    @Override
    public HttpHeaders headers() {
        return this.headers;
    }

    public ImmutableList<String> headers(CharSequence name) {
        return this.headers.getAll(name);
    }

    @Override
    public HttpMessageBody body() {
        return this.body;
    }

    public boolean isSecure() {
        return this.secure;
    }

    public InetSocketAddress clientAddress() {
        return this.clientAddress;
    }

    public <T> Observable<DecodedRequest<T>> decode(Function<ByteBuf, T> decoder, int maxContentBytes) {
        return this.body.aggregate(maxContentBytes).map(bytes -> decoder.apply(Unpooled.copiedBuffer((ByteBuf)bytes))).map(x$0 -> new DecodedRequest(x$0));
    }

    public Observable<DecodedRequest<FormData>> decodePostParams(int maxContentBytes) {
        return this.decode(this::toFormData, maxContentBytes);
    }

    public <T> Observable<FullHttpRequest> toFullRequest(int maxContentLength) {
        return this.body.aggregate(maxContentLength).map(decoded -> new FullHttpRequest.Builder(this, decoded.copy().array())).map(FullHttpRequest.Builder::build);
    }

    private FormData toFormData(ByteBuf byteBuf) {
        HttpPostRequestDecoder postRequestDecoder = new HttpPostRequestDecoder((HttpDataFactory)new DefaultHttpDataFactory(false), (io.netty.handler.codec.http.HttpRequest)new DefaultHttpRequest(this.version, this.method, this.url.toString()));
        postRequestDecoder.offer((HttpContent)new DefaultHttpContent(byteBuf));
        postRequestDecoder.offer((HttpContent)new DefaultLastHttpContent());
        return new FormData(postRequestDecoder);
    }

    public Optional<String> queryParam(String name) {
        return this.url.queryParam(name);
    }

    public Iterable<String> queryParams(String name) {
        return this.url.queryParams(name);
    }

    public Map<String, List<String>> queryParams() {
        return this.url.queryParams();
    }

    public Iterable<String> queryParamNames() {
        return this.url.queryParamNames();
    }

    public Optional<HttpCookie> cookie(String name) {
        return CookiesSupport.findCookie(this.cookies, name);
    }

    public ImmutableList<HttpCookie> cookies() {
        return this.cookies;
    }

    public Builder newBuilder() {
        return new Builder(this);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("version", (Object)this.version).add("method", (Object)this.method).add("uri", (Object)this.url).add("headers", (Object)this.headers).add("cookies", this.cookies).add("id", this.id).add("clientAddress", (Object)this.clientAddress).toString();
    }

    public Optional<Integer> contentLength() {
        return this.header(HttpHeaderNames.CONTENT_LENGTH).map(Integer::valueOf);
    }

    public boolean chunked() {
        return HttpMessageSupport.chunked(this.headers);
    }

    public static final class Builder
    extends HttpMessageBuilder<Builder, HttpRequest> {
        private static final InetSocketAddress LOCAL_HOST = InetSocketAddress.createUnresolved("127.0.0.1", 0);
        private Object id;
        private HttpMethod method;
        private InetSocketAddress clientAddress = LOCAL_HOST;
        private boolean validate = true;
        private Url url;
        private boolean secure;
        private List<HttpCookie> cookies = new ArrayList<HttpCookie>();

        private Builder(HttpRequest request) {
            this.id = request.id;
            this.secure = request.secure;
            this.url = request.url;
            this.method = request.method;
            this.clientAddress = request.clientAddress;
            this.cookies = new ArrayList<HttpCookie>((Collection<HttpCookie>)request.cookies);
            this.body(request.body);
            this.headers(request.headers.newBuilder());
            this.version(request.version);
        }

        public Builder(FullHttpRequest request) {
            this.id = request.id();
            this.secure = request.isSecure();
            this.url = request.url();
            this.method = HttpMethod.valueOf((String)request.method().name());
            this.cookies = new ArrayList<HttpCookie>(request.cookies());
            this.headers(request.headers().newBuilder());
            this.version(HttpVersion.valueOf((String)request.version().toString()));
        }

        public Builder(HttpMethod method) {
            this.method = method;
            this.headers(new HttpHeaders.Builder());
        }

        public Builder(HttpMethod method, String uri) {
            this.method = method;
            this.url = Url.Builder.url(uri).build();
            this.secure = this.url.isSecure();
            this.headers(new HttpHeaders.Builder());
        }

        public static Builder get(String uri) {
            return new Builder(HttpMethod.GET, uri);
        }

        public static Builder head(String uri) {
            return new Builder(HttpMethod.HEAD, uri);
        }

        public static Builder post(String uri) {
            return new Builder(HttpMethod.POST, uri);
        }

        public static Builder delete(String uri) {
            return new Builder(HttpMethod.DELETE, uri);
        }

        public static Builder put(String uri) {
            return new Builder(HttpMethod.PUT, uri);
        }

        public static Builder patch(String uri) {
            return new Builder(HttpMethod.PATCH, uri);
        }

        public Builder id(Object id) {
            this.id = id;
            return this;
        }

        public Builder method(HttpMethod method) {
            this.method = method;
            return this;
        }

        public Builder secure(boolean secure) {
            this.secure = secure;
            return this;
        }

        public Builder uri(String uri) {
            return this.url(Url.Builder.url(uri).build());
        }

        public Builder url(Url url) {
            this.url = (Url)Preconditions.checkNotNull((Object)url);
            this.secure = url.isSecure();
            return this;
        }

        public Builder addCookie(HttpCookie cookie) {
            this.cookies.add((HttpCookie)Preconditions.checkNotNull((Object)cookie));
            return this;
        }

        public Builder addCookie(String name, String value) {
            return this.addCookie(HttpCookie.cookie(name, value, new HttpCookieAttribute[0]));
        }

        public Builder removeCookie(String name) {
            CookiesSupport.findCookie(this.cookies, name).ifPresent(this.cookies::remove);
            return this;
        }

        public Builder clientAddress(InetSocketAddress address) {
            this.clientAddress = address;
            return this;
        }

        public Builder enableKeepAlive() {
            this.headers().add(HttpHeaderNames.CONNECTION, HttpHeaderValues.KEEP_ALIVE);
            return this;
        }

        public Builder disableValidation() {
            this.validate = false;
            return this;
        }

        @Override
        public HttpRequest build() {
            if (this.validate) {
                this.ensureContentLengthIsValid();
                this.ensureMethodIsValid();
            }
            this.setHostHeader();
            return new HttpRequest(this);
        }

        private void setHostHeader() {
            this.url.authority().ifPresent(authority -> {
                Builder cfr_ignored_0 = (Builder)this.header(HttpHeaderNames.HOST, authority.hostAndPort());
            });
        }

        private void ensureMethodIsValid() {
            Preconditions.checkArgument((boolean)this.isMethodValid(), (String)"Unrecognised HTTP method=%s", (Object[])new Object[]{this.method});
        }

        private boolean isMethodValid() {
            return this.method == HttpMethod.CONNECT || this.method == HttpMethod.DELETE || this.method == HttpMethod.GET || this.method == HttpMethod.HEAD || this.method == HttpMethod.OPTIONS || this.method == HttpMethod.PATCH || this.method == HttpMethod.POST || this.method == HttpMethod.PUT || this.method == HttpMethod.TRACE;
        }
    }

    public final class DecodedRequest<T> {
        private final Builder requestBuilder;
        private final T content;

        private DecodedRequest(T content) {
            this.requestBuilder = (Builder)HttpRequest.this.newBuilder().body(content.toString());
            this.content = content;
        }

        public Builder requestBuilder() {
            return this.requestBuilder;
        }

        public T body() {
            return this.content;
        }
    }
}

