/*
 * Decompiled with CFR 0.152.
 */
package com.hotels.styx.api;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Sets;
import com.google.common.net.MediaType;
import com.hotels.styx.api.HttpCookie;
import com.hotels.styx.api.HttpCookieAttribute;
import com.hotels.styx.api.HttpHeaderNames;
import com.hotels.styx.api.HttpHeaders;
import com.hotels.styx.api.HttpMessage;
import com.hotels.styx.api.HttpMessageBody;
import com.hotels.styx.api.HttpMessageBuilder;
import com.hotels.styx.api.HttpMessageSupport;
import com.hotels.styx.api.HttpRequest;
import com.hotels.styx.api.messages.FullHttpResponse;
import com.hotels.styx.api.support.CookiesSupport;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.util.ReferenceCountUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import rx.Observable;

public final class HttpResponse
implements HttpMessage {
    private static final Set<HttpResponseStatus> REDIRECT_STATUS = Sets.newHashSet((Object[])new HttpResponseStatus[]{HttpResponseStatus.FOUND, HttpResponseStatus.SEE_OTHER, HttpResponseStatus.TEMPORARY_REDIRECT, HttpResponseStatus.MULTIPLE_CHOICES, HttpResponseStatus.MOVED_PERMANENTLY, HttpResponseStatus.TEMPORARY_REDIRECT});
    private final HttpRequest request;
    private final HttpVersion version;
    private final HttpResponseStatus status;
    private final HttpHeaders headers;
    private final HttpMessageBody body;
    private final ImmutableList<HttpCookie> cookies;

    private HttpResponse(Builder builder) {
        this.request = builder.request;
        this.version = builder.version();
        this.status = builder.status;
        this.headers = builder.headers().build();
        this.cookies = ImmutableList.copyOf((Collection)builder.cookies);
        this.body = builder.body();
    }

    public HttpRequest request() {
        return this.request;
    }

    @Override
    public HttpVersion version() {
        return this.version;
    }

    public HttpResponseStatus status() {
        return this.status;
    }

    public Optional<String> header(CharSequence name) {
        return this.headers.get(name);
    }

    public ImmutableList<String> headers(CharSequence name) {
        return this.headers.getAll(name);
    }

    @Override
    public HttpHeaders headers() {
        return this.headers;
    }

    public ImmutableList<HttpCookie> cookies() {
        return this.cookies;
    }

    public Optional<HttpCookie> cookie(String name) {
        return CookiesSupport.findCookie(this.cookies, name);
    }

    @Override
    public HttpMessageBody body() {
        return this.body;
    }

    public Builder newBuilder() {
        return new Builder(this);
    }

    public boolean isRedirect() {
        return REDIRECT_STATUS.contains(this.status);
    }

    public Optional<String> contentType() {
        return this.header(HttpHeaderNames.CONTENT_TYPE);
    }

    public Optional<Integer> contentLength() {
        return this.header(HttpHeaderNames.CONTENT_LENGTH).map(Integer::valueOf);
    }

    public boolean chunked() {
        return HttpMessageSupport.chunked(this.headers);
    }

    public <T> Observable<DecodedResponse<T>> decode(Function<ByteBuf, T> decoder, int maxContentBytes) {
        return this.body.aggregate(maxContentBytes).map(bytes -> decoder.apply(Unpooled.copiedBuffer((ByteBuf)bytes))).map(content -> new DecodedResponse(this, content));
    }

    public Observable<FullHttpResponse> toFullResponse(int maxContentLength) {
        return this.body.aggregate(maxContentLength).map(decoded -> new FullHttpResponse.Builder(this, decoded.copy().array())).map(FullHttpResponse.Builder::build);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("request", (Object)this.request).add("version", (Object)this.version).add("status", (Object)this.status).add("headers", (Object)this.headers).add("cookies", this.cookies).toString();
    }

    public int hashCode() {
        return Objects.hash(this.request, this.version, this.status, this.headers, this.cookies);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        HttpResponse other = (HttpResponse)obj;
        return Objects.equals(this.request, other.request) && Objects.equals(this.version, other.version) && Objects.equals(this.status, other.status) && Objects.equals(this.headers, other.headers) && Objects.equals(this.cookies, other.cookies);
    }

    public static class Builder
    extends HttpMessageBuilder<Builder, HttpResponse> {
        private HttpRequest request;
        private HttpResponseStatus status = HttpResponseStatus.OK;
        private boolean validate = true;
        private List<HttpCookie> cookies = new ArrayList<HttpCookie>();

        public Builder(HttpResponseStatus status) {
            this.status = status;
            this.headers(new HttpHeaders.Builder());
        }

        private Builder(HttpResponse response) {
            this.request = response.request;
            this.status = response.status;
            this.headers(response.headers.newBuilder());
            this.cookies = new ArrayList<HttpCookie>((Collection<HttpCookie>)response.cookies);
            this.version(response.version);
            this.body(response.body);
        }

        public Builder(FullHttpResponse response, Observable<ByteBuf> body) {
            this.status = HttpResponseStatus.valueOf((int)response.status().code());
            this.headers(response.headers().newBuilder());
            this.cookies = new ArrayList<HttpCookie>(response.cookies());
            this.version(HttpVersion.valueOf((String)response.version().toString()));
            this.body(body);
        }

        public static Builder newBuilder(HttpResponse response) {
            return new Builder(response);
        }

        public static Builder response() {
            return Builder.response(HttpResponseStatus.OK);
        }

        public static Builder response(HttpResponseStatus status) {
            return new Builder(status);
        }

        public Builder request(HttpRequest request) {
            this.request = request;
            return this;
        }

        public Builder status(HttpResponseStatus status) {
            this.status = status;
            return this;
        }

        public Builder disableCaching() {
            this.header((CharSequence)"Pragma", "no-cache");
            this.header((CharSequence)"Expires", "Mon, 1 Jan 2007 08:00:00 GMT");
            this.header((CharSequence)"Cache-Control", "no-cache,must-revalidate,no-store");
            return this;
        }

        public Builder addCookie(HttpCookie cookie) {
            this.cookies.add((HttpCookie)Preconditions.checkNotNull((Object)cookie));
            return this;
        }

        public Builder addCookie(String name, String value) {
            return this.addCookie(HttpCookie.cookie(name, value, new HttpCookieAttribute[0]));
        }

        public Builder removeCookie(String name) {
            CookiesSupport.findCookie(this.cookies, name).ifPresent(cookie -> this.cookies.remove(cookie));
            return this;
        }

        public Builder contentType(MediaType contentType) {
            this.header(HttpHeaderNames.CONTENT_TYPE, contentType.toString());
            return this;
        }

        public Builder removeBody() {
            return (Builder)this.body((Observable<ByteBuf>)this.body.content().doOnNext(ReferenceCountUtil::release).ignoreElements());
        }

        public Builder validateContentLength() {
            this.ensureContentLengthIsValid();
            return this;
        }

        @Override
        public HttpResponse build() {
            return new HttpResponse(this);
        }
    }

    public static final class DecodedResponse<T> {
        private final Builder responseBuilder;
        private final T content;

        private DecodedResponse(HttpResponse response, T content) {
            this.responseBuilder = (Builder)response.newBuilder().body(HttpMessageBody.NO_BODY);
            this.content = content;
        }

        public Builder responseBuilder() {
            return this.responseBuilder;
        }

        public T body() {
            return this.content;
        }
    }
}

