/*
 * Decompiled with CFR 0.152.
 */
package com.hotels.styx.api.client;

import com.hotels.styx.api.client.Connection;
import com.hotels.styx.api.client.ConnectionDestination;
import com.hotels.styx.api.client.Origin;
import java.io.Closeable;
import java.util.function.Function;
import rx.Observable;

public interface ConnectionPool
extends Closeable,
ConnectionDestination {
    @Override
    public Origin getOrigin();

    public Observable<Connection> borrowConnection();

    public boolean returnConnection(Connection var1);

    public boolean closeConnection(Connection var1);

    public boolean isExhausted();

    public Stats stats();

    @Override
    public Settings settings();

    @Override
    default public <T> Observable<T> withConnection(Function<Connection, Observable<T>> task) {
        return this.borrowConnection().flatMap(connection -> ((Observable)task.apply((Connection)connection)).doOnCompleted(() -> this.returnConnection((Connection)connection)).doOnError(throwable -> this.closeConnection((Connection)connection)));
    }

    @Override
    default public void close() {
    }

    public static interface Factory
    extends ConnectionDestination.Factory {
        @Override
        public ConnectionPool create(Origin var1);
    }

    public static interface Stats {
        public int busyConnectionCount();

        public int availableConnectionCount();

        public int pendingConnectionCount();

        public long timeToFirstByteMs();

        public int connectionAttempts();

        public int connectionFailures();

        public int closedConnections();

        public int terminatedConnections();
    }

    public static interface Settings
    extends Connection.Settings {
        public int maxConnectionsPerHost();

        public int maxPendingConnectionsPerHost();

        public int pendingConnectionTimeoutMillis();

        public long connectionExpirationSeconds();
    }
}

