/*
 * Decompiled with CFR 0.152.
 */
package com.hotels.styx.api.client;

import com.google.common.base.Preconditions;
import com.google.common.net.HostAndPort;
import com.hotels.styx.api.Id;
import java.util.Collection;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;

public class Origin
implements Comparable<Origin> {
    private final Id applicationId;
    private final HostAndPort host;
    private final String hostAsString;
    private final Id originId;
    private final int hashCode;

    public static Builder newOriginBuilder(HostAndPort host) {
        return new Builder(host);
    }

    public static Builder newOriginBuilder(String host, int port) {
        return new Builder(HostAndPort.fromParts((String)host, (int)port));
    }

    public static Builder newOriginBuilder(Origin origin) {
        return new Builder(origin);
    }

    private Origin(Builder builder) {
        this.host = (HostAndPort)Preconditions.checkNotNull((Object)builder.host);
        this.hostAsString = this.host.toString();
        this.applicationId = (Id)Preconditions.checkNotNull((Object)builder.applicationId);
        this.originId = (Id)Preconditions.checkNotNull((Object)builder.originId);
        this.hashCode = Objects.hash(this.applicationId, this.host, this.originId);
    }

    Origin(String originId, String host) {
        this.originId = Id.id(originId);
        this.host = HostAndPort.fromString((String)host);
        this.hostAsString = this.host.toString();
        this.applicationId = Id.GENERIC_APP;
        this.hashCode = Objects.hash(this.host, this.originId);
    }

    public static void checkThatOriginsAreDistinct(Collection<Origin> origins) {
        Set ids = origins.stream().map(Origin::id).collect(Collectors.toSet());
        Preconditions.checkArgument((ids.size() == origins.size() ? 1 : 0) != 0, (Object)("Duplicate ids in " + origins));
        Set hosts = origins.stream().map(Origin::hostAsString).collect(Collectors.toSet());
        Preconditions.checkArgument((hosts.size() == origins.size() ? 1 : 0) != 0, (Object)("Duplicate host and port in " + origins));
    }

    public String applicationInfo() {
        return this.applicationId.toString().toUpperCase() + "-" + this.host;
    }

    public HostAndPort host() {
        return this.host;
    }

    public String hostAsString() {
        return this.hostAsString;
    }

    public Id applicationId() {
        return this.applicationId;
    }

    public Id id() {
        return this.originId;
    }

    String idAsString() {
        return this.originId.toString();
    }

    public int hashCode() {
        return this.hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Origin other = (Origin)obj;
        return Objects.equals(this.applicationId, other.applicationId) && Objects.equals(this.host, other.host) && Objects.equals(this.originId, other.originId);
    }

    public String toString() {
        return String.format("%s:%s:%s", this.applicationId, this.originId, this.host);
    }

    @Override
    public int compareTo(Origin other) {
        return this.host.toString().compareTo(other.host().toString());
    }

    public static final class Builder {
        private final HostAndPort host;
        private Id applicationId = Id.GENERIC_APP;
        private Id originId = Id.id("anonymous-origin");

        private Builder(HostAndPort host) {
            this.host = host;
        }

        private Builder(Origin origin) {
            this.host = origin.host;
            this.applicationId = origin.applicationId;
            this.originId = origin.originId;
        }

        public Builder id(String id) {
            this.originId = Id.id(id);
            return this;
        }

        public Builder applicationId(Id applicationId) {
            this.applicationId = applicationId;
            return this;
        }

        public Builder applicationId(String applicationId) {
            this.applicationId = Id.id(applicationId);
            return this;
        }

        public Origin build() {
            return new Origin(this);
        }
    }
}

