/*
 * Decompiled with CFR 0.152.
 */
package com.hotels.styx.api.client;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.hotels.styx.api.Id;
import com.hotels.styx.api.client.Origin;
import com.hotels.styx.api.client.RemoteHost;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public final class OriginsSnapshot {
    private final Id appId;
    private final Set<Origin> activeOrigins;
    private final Set<Origin> inactiveOrigins;
    private final Set<Origin> disabledOrigins;
    private final Map<Id, Origin> allOriginsById = new HashMap<Id, Origin>();

    OriginsSnapshot(String appId, Collection<Origin> activeOrigins, Collection<Origin> inactiveOrigins, Collection<Origin> disabledOrigins) {
        this.appId = Id.id(appId);
        this.activeOrigins = OriginsSnapshot.withAppId(activeOrigins, appId);
        this.inactiveOrigins = OriginsSnapshot.withAppId(inactiveOrigins, appId);
        this.disabledOrigins = OriginsSnapshot.withAppId(disabledOrigins, appId);
        this.mapOriginsById();
    }

    public OriginsSnapshot(Id appId, Collection<RemoteHost> activeOrigins, Collection<RemoteHost> inactiveOrigins, Collection<RemoteHost> disabledOrigins) {
        this.appId = (Id)Preconditions.checkNotNull((Object)appId);
        this.activeOrigins = this.mapToOrigins(activeOrigins);
        this.inactiveOrigins = this.mapToOrigins(inactiveOrigins);
        this.disabledOrigins = this.mapToOrigins(disabledOrigins);
        this.mapOriginsById();
    }

    private void mapOriginsById() {
        this.activeOrigins.forEach(origin -> this.allOriginsById.put(origin.id(), (Origin)origin));
        this.inactiveOrigins.forEach(origin -> this.allOriginsById.put(origin.id(), (Origin)origin));
        this.disabledOrigins.forEach(origin -> this.allOriginsById.put(origin.id(), (Origin)origin));
    }

    private Set<Origin> mapToOrigins(Collection<RemoteHost> activeOrigins) {
        return activeOrigins.stream().map(RemoteHost::origin).collect(Collectors.toSet());
    }

    private static Set<Origin> withAppId(Collection<Origin> origins, String appId) {
        return origins.stream().map(origin -> Origin.newOriginBuilder(origin).applicationId(appId).build()).collect(Collectors.toSet());
    }

    public Id appId() {
        return this.appId;
    }

    String appIdAsString() {
        return this.appId.toString();
    }

    public Set<Origin> activeOrigins() {
        return this.activeOrigins;
    }

    public Set<Origin> inactiveOrigins() {
        return this.inactiveOrigins;
    }

    public Set<Origin> disabledOrigins() {
        return this.disabledOrigins;
    }

    public boolean containsOrigin(Id originId) {
        return this.allOriginsById.containsKey(originId);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("appId", (Object)this.appId).add("activeOrigins", this.activeOrigins).add("inactiveOrigins", this.inactiveOrigins).add("disabledOrigins", this.disabledOrigins).toString();
    }
}

