/*
 * Decompiled with CFR 0.152.
 */
package com.hotels.styx.api.client;

import com.hotels.styx.api.HttpClient;
import com.hotels.styx.api.Id;
import com.hotels.styx.api.client.Origin;
import com.hotels.styx.api.client.loadbalancing.spi.LoadBalancingMetric;
import com.hotels.styx.api.client.loadbalancing.spi.LoadBalancingMetricSupplier;
import java.util.Objects;

public final class RemoteHost {
    private final Origin origin;
    private final HttpClient hostClient;
    private final LoadBalancingMetricSupplier metricSupplier;

    private RemoteHost(Origin origin, HttpClient hostClient, LoadBalancingMetricSupplier metricSupplier) {
        this.origin = Objects.requireNonNull(origin);
        this.hostClient = Objects.requireNonNull(hostClient);
        this.metricSupplier = Objects.requireNonNull(metricSupplier);
    }

    public static RemoteHost remoteHost(Origin origin, HttpClient client, LoadBalancingMetricSupplier metricSupplier) {
        return new RemoteHost(origin, client, metricSupplier);
    }

    public Id id() {
        return this.origin().id();
    }

    public Origin origin() {
        return this.origin;
    }

    public HttpClient hostClient() {
        return this.hostClient;
    }

    public LoadBalancingMetric metric() {
        return this.metricSupplier.loadBalancingMetric();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("RemoteHost{");
        sb.append("origin=").append(this.origin);
        sb.append('}');
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RemoteHost that = (RemoteHost)o;
        return Objects.equals(this.origin, that.origin);
    }

    public int hashCode() {
        return Objects.hash(this.origin);
    }
}

