/*
 * Decompiled with CFR 0.152.
 */
package com.hotels.styx.api.client;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.base.Throwables;
import com.google.common.io.ByteStreams;
import com.hotels.styx.api.HttpClient;
import com.hotels.styx.api.HttpHeader;
import com.hotels.styx.api.HttpRequest;
import com.hotels.styx.api.HttpResponse;
import com.hotels.styx.api.common.Joiners;
import io.netty.handler.codec.http.HttpResponseStatus;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Objects;
import java.util.Optional;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import rx.Observable;

public class UrlConnectionHttpClient
implements HttpClient {
    private static final X509TrustManager TRUST_ALL = new X509TrustManager(){

        @Override
        public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        }

        @Override
        public void checkServerTrusted(X509Certificate[] chain, String authType) {
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return null;
        }
    };
    private final int connectTimeoutMillis;
    private final int readTimeoutMillis;
    private final SSLSocketFactory sslSocketFactory;

    public UrlConnectionHttpClient(int connectTimeoutMillis, int readTimeoutMillis) {
        this(connectTimeoutMillis, readTimeoutMillis, UrlConnectionHttpClient.sslSocketFactory("TLS"));
    }

    public UrlConnectionHttpClient(int connectTimeoutMillis, int readTimeoutMillis, String protocol) {
        this(connectTimeoutMillis, readTimeoutMillis, UrlConnectionHttpClient.sslSocketFactory(protocol));
    }

    private UrlConnectionHttpClient(int connectTimeoutMillis, int readTimeoutMillis, SSLSocketFactory sslSocketFactory) {
        this.connectTimeoutMillis = connectTimeoutMillis;
        this.readTimeoutMillis = readTimeoutMillis;
        this.sslSocketFactory = (SSLSocketFactory)Preconditions.checkNotNull((Object)sslSocketFactory);
    }

    private static SSLSocketFactory sslSocketFactory(String protocol) {
        try {
            SSLContext context = SSLContext.getInstance(protocol);
            context.init(null, new TrustManager[]{TRUST_ALL}, new SecureRandom());
            return context.getSocketFactory();
        }
        catch (KeyManagementException | NoSuchAlgorithmException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    @Override
    public Observable<HttpResponse> sendRequest(HttpRequest request) {
        try {
            HttpURLConnection connection = this.openConnection(request);
            this.prepareRequest(connection, request);
            return Observable.just((Object)this.readResponse(connection));
        }
        catch (IOException e) {
            return Observable.error((Throwable)e);
        }
    }

    private HttpURLConnection openConnection(HttpRequest request) throws IOException {
        URL url = request.url().toURL();
        URLConnection urlConnection = url.openConnection();
        HttpURLConnection connection = "https".equals(url.getProtocol()) ? this.httpsURLConnection((HttpsURLConnection)urlConnection) : (HttpURLConnection)urlConnection;
        connection.setConnectTimeout(this.connectTimeoutMillis);
        connection.setReadTimeout(this.readTimeoutMillis);
        return connection;
    }

    private HttpsURLConnection httpsURLConnection(HttpsURLConnection urlConnection) {
        urlConnection.setSSLSocketFactory(this.sslSocketFactory);
        return urlConnection;
    }

    private void prepareRequest(HttpURLConnection connection, HttpRequest request) throws IOException {
        connection.setRequestMethod(request.method().name());
        connection.setRequestProperty("Connection", "close");
        connection.setDoInput(true);
        for (HttpHeader httpHeader : request.headers()) {
            connection.addRequestProperty(httpHeader.name(), httpHeader.value());
        }
    }

    private HttpResponse readResponse(HttpURLConnection connection) throws IOException {
        int status = connection.getResponseCode();
        HttpResponse.Builder response = HttpResponse.Builder.response(HttpResponseStatus.valueOf((int)status));
        try (InputStream stream = UrlConnectionHttpClient.getInputStream(connection, status);){
            byte[] content = ByteStreams.toByteArray((InputStream)stream);
            if (content.length > 0) {
                response.body(content);
            }
            connection.getHeaderFields().forEach((key, value) -> {
                if (!Strings.isNullOrEmpty((String)key)) {
                    response.header((CharSequence)key, Joiners.JOINER_ON_COMMA.join((Iterable)value));
                }
            });
        }
        return response.build();
    }

    private static InputStream getInputStream(HttpURLConnection connection, int status) throws IOException {
        if (status >= 400) {
            return Optional.ofNullable(connection.getErrorStream()).orElseGet(() -> new EmptyInputStream());
        }
        return connection.getInputStream();
    }

    public int hashCode() {
        return Objects.hash(this.connectTimeoutMillis, this.readTimeoutMillis);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        UrlConnectionHttpClient other = (UrlConnectionHttpClient)obj;
        return Objects.equals(this.connectTimeoutMillis, other.connectTimeoutMillis) && Objects.equals(this.readTimeoutMillis, other.readTimeoutMillis);
    }

    private static class EmptyInputStream
    extends InputStream {
        private EmptyInputStream() {
        }

        @Override
        public int read() throws IOException {
            return -1;
        }
    }
}

