/*
 * Decompiled with CFR 0.152.
 */
package com.hotels.styx.api.common;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.StringDescription;

public final class MorePreconditions {
    public static String checkNotEmpty(String value) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)value) ? 1 : 0) != 0);
        return value;
    }

    public static <T> T checkArgument(T reference, boolean expression) {
        Preconditions.checkArgument((boolean)expression);
        return reference;
    }

    public static <T> T checkArgument(T reference, Matcher<T> condition) {
        return MorePreconditions.checkArgument(reference, condition, "argument");
    }

    public static <T> T checkArgument(T reference, Matcher<T> condition, String referenceName) {
        if (!condition.matches(reference)) {
            StringDescription description = new StringDescription();
            description.appendText(referenceName).appendText("\nExpected: ").appendDescriptionOf(condition).appendText("\n     but: ");
            condition.describeMismatch(reference, (Description)description);
            throw new IllegalArgumentException(description.toString());
        }
        return reference;
    }

    public static Matcher<Integer> inRange(int minimum, int maximum) {
        return Matchers.allOf((Matcher)Matchers.greaterThanOrEqualTo((Comparable)Integer.valueOf(minimum)), (Matcher)Matchers.lessThanOrEqualTo((Comparable)Integer.valueOf(maximum)));
    }

    private MorePreconditions() {
    }
}

