/*
 * Decompiled with CFR 0.152.
 */
package com.hotels.styx.api.common;

import java.util.stream.Collectors;
import java.util.stream.Stream;

public final class StackDump {
    private static final String LINE_SEPARATOR = System.lineSeparator();

    private StackDump() {
    }

    public static Stream<String> stack() {
        return Stream.of(Thread.currentThread().getStackTrace()).map(Object::toString).filter(StackDump::notFromThisClass).filter(StackDump::notFromThreadClass);
    }

    public static String string(Stream<String> stack) {
        return stack.map(stackTraceElement -> "  at " + stackTraceElement).collect(Collectors.joining(LINE_SEPARATOR));
    }

    public static void dump(Stream<String> stack) {
        System.out.println(StackDump.string(stack));
    }

    public static void dump(Stream<String> stack, String prefix, Object ... args) {
        System.out.println(String.format(prefix, args) + LINE_SEPARATOR + StackDump.string(stack));
    }

    private static boolean notFromThisClass(String stackTraceElement) {
        return !stackTraceElement.contains(StackDump.class.getName());
    }

    private static boolean notFromThreadClass(String stackTraceElement) {
        return !stackTraceElement.contains(Thread.class.getName());
    }
}

