/*
 * Decompiled with CFR 0.152.
 */
package com.hotels.styx.api.configuration;

import com.hotels.styx.api.configuration.ConfigurationException;
import com.hotels.styx.api.configuration.NoSystemPropertyDefined;
import com.hotels.styx.api.configuration.Setting;
import com.hotels.styx.api.io.ResourceFactory;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Optional;

public final class SystemSettings {
    private SystemSettings() {
    }

    public static <T> T valueOf(Setting<T> setting) {
        return setting.value().orElseThrow(() -> new NoSystemPropertyDefined(setting.name()));
    }

    public static <T> T valueOf(Setting<T> setting, T defaultValue) {
        return setting.value().orElse(defaultValue);
    }

    public static class String
    extends SystemSetting<java.lang.String> {
        public String(java.lang.String systemVariable) {
            super(systemVariable);
        }

        @Override
        protected java.lang.String convert(java.lang.String value) {
            return value;
        }
    }

    public static class Location
    extends SystemSetting<Path> {
        public Location(java.lang.String systemVariable) {
            super(systemVariable);
        }

        @Override
        protected Path convert(java.lang.String value) {
            Path location = Paths.get(this.removeFilePrefix(value), new java.lang.String[0]);
            if (!Files.isReadable(location)) {
                throw new ConfigurationException(java.lang.String.format("%s=%s is not a readable configuration path.", this.name(), location));
            }
            return location;
        }

        private java.lang.String removeFilePrefix(java.lang.String value) {
            return value.replaceFirst("file:", "");
        }
    }

    public static class Resource
    extends SystemSetting<com.hotels.styx.api.Resource> {
        public Resource(java.lang.String systemVariable) {
            super(systemVariable);
        }

        @Override
        protected com.hotels.styx.api.Resource convert(java.lang.String value) {
            return ResourceFactory.newResource(value);
        }
    }

    public static abstract class SystemSetting<T>
    implements Setting<T> {
        private final java.lang.String systemVariable;

        protected SystemSetting(java.lang.String systemVariable) {
            this.systemVariable = systemVariable;
        }

        @Override
        public Optional<T> value() {
            java.lang.String value = System.getProperty(this.systemVariable);
            return Optional.ofNullable(value).map(this::convert);
        }

        @Override
        public java.lang.String name() {
            return this.systemVariable;
        }

        protected abstract T convert(java.lang.String var1);
    }
}

