/*
 * Decompiled with CFR 0.152.
 */
package com.hotels.styx.api.http.handlers;

import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.net.MediaType;
import com.hotels.styx.api.HttpRequest;
import com.hotels.styx.api.HttpResponse;
import com.hotels.styx.api.http.handlers.BaseHttpHandler;
import io.netty.handler.codec.http.HttpResponseStatus;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import java.util.concurrent.TimeUnit;

public class CachedBodyHttpHandler
extends BaseHttpHandler {
    private final String contentType;
    private final java.util.function.Supplier<Body> bodySupplier;

    public CachedBodyHttpHandler(Builder builder) {
        this.contentType = builder.contentType.toString();
        java.util.function.Supplier contentSupplier = builder.contentSupplier;
        Charset charset = builder.charset;
        java.util.function.Supplier<Body> bodySupplier = () -> this.lambda$new$0((java.util.function.Supplier)contentSupplier, charset);
        this.bodySupplier = () -> ((Supplier)Suppliers.memoizeWithExpiration(bodySupplier::get, (long)builder.expiration, (TimeUnit)builder.expirationUnit)).get();
    }

    @Override
    public HttpResponse doHandle(HttpRequest request) {
        return this.bodySupplier.get().toResponse();
    }

    private /* synthetic */ Body lambda$new$0(java.util.function.Supplier contentSupplier, Charset charset) {
        return new Body((String)contentSupplier.get(), charset);
    }

    public static final class Builder {
        private final java.util.function.Supplier<String> contentSupplier;
        private MediaType contentType = MediaType.PLAIN_TEXT_UTF_8;
        private Charset charset = StandardCharsets.UTF_8;
        private long expiration = 1L;
        private TimeUnit expirationUnit = TimeUnit.SECONDS;

        public Builder(java.util.function.Supplier<String> contentSupplier) {
            this.contentSupplier = Objects.requireNonNull(contentSupplier);
        }

        public Builder contentType(MediaType contentType) {
            this.contentType = Objects.requireNonNull(contentType);
            return this;
        }

        public Builder charset(Charset charset) {
            this.charset = Objects.requireNonNull(charset);
            return this;
        }

        public Builder expiration(long expiration) {
            this.expiration = Objects.requireNonNull(expiration);
            return this;
        }

        public Builder expirationUnit(TimeUnit expirationUnit) {
            this.expirationUnit = Objects.requireNonNull(expirationUnit);
            return this;
        }

        public CachedBodyHttpHandler build() {
            return new CachedBodyHttpHandler(this);
        }
    }

    private class Body {
        private final String content;
        private final int contentLength;

        Body(String content, Charset charset) {
            this.content = content;
            this.contentLength = content.getBytes(charset).length;
        }

        HttpResponse toResponse() {
            return ((HttpResponse.Builder)((HttpResponse.Builder)((HttpResponse.Builder)HttpResponse.Builder.response(HttpResponseStatus.OK).header((CharSequence)"Content-Type", CachedBodyHttpHandler.this.contentType)).header((CharSequence)"Content-Length", this.contentLength)).body(this.content)).build();
        }
    }
}

