/*
 * Decompiled with CFR 0.152.
 */
package com.hotels.styx.api.http.handlers;

import com.google.common.base.Preconditions;
import com.hotels.styx.api.HttpHandler;
import com.hotels.styx.api.HttpRequest;
import com.hotels.styx.api.HttpResponse;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpResponseStatus;
import rx.Observable;

public class HttpMethodFilteringHandler
implements HttpHandler {
    private final HttpMethod method;
    private final HttpHandler httpHandler;
    private final String errorBody;

    public HttpMethodFilteringHandler(HttpMethod method, HttpHandler httpHandler) {
        this.method = (HttpMethod)Preconditions.checkNotNull((Object)method);
        this.httpHandler = (HttpHandler)Preconditions.checkNotNull((Object)httpHandler);
        this.errorBody = String.format("%s. Only [%s] is allowed for this request.", HttpResponseStatus.METHOD_NOT_ALLOWED.reasonPhrase(), method);
    }

    @Override
    public Observable<HttpResponse> handle(HttpRequest request) {
        if (!this.method.equals((Object)request.method())) {
            return Observable.just((Object)((HttpResponse.Builder)HttpResponse.Builder.response(HttpResponseStatus.METHOD_NOT_ALLOWED).body(this.errorBody)).build());
        }
        return this.httpHandler.handle(request);
    }
}

