/*
 * Decompiled with CFR 0.152.
 */
package com.hotels.styx.api.http.handlers;

import com.google.common.base.Charsets;
import com.google.common.base.Preconditions;
import com.google.common.net.MediaType;
import com.hotels.styx.api.HttpRequest;
import com.hotels.styx.api.HttpResponse;
import com.hotels.styx.api.http.handlers.BaseHttpHandler;
import io.netty.handler.codec.http.HttpResponseStatus;
import java.nio.charset.Charset;

public class StaticBodyHttpHandler
extends BaseHttpHandler {
    private final MediaType contentType;
    private final String body;
    private final int contentLength;

    public StaticBodyHttpHandler(MediaType contentType, String body) {
        this(contentType, body, Charsets.UTF_8);
    }

    public StaticBodyHttpHandler(MediaType contentType, String body, Charset charset) {
        this.contentType = (MediaType)Preconditions.checkNotNull((Object)contentType);
        this.body = (String)Preconditions.checkNotNull((Object)body);
        this.contentLength = body.getBytes(charset).length;
    }

    @Override
    public HttpResponse doHandle(HttpRequest request) {
        return ((HttpResponse.Builder)((HttpResponse.Builder)((HttpResponse.Builder)HttpResponse.Builder.response(HttpResponseStatus.OK).header((CharSequence)"Content-Type", this.contentType.toString())).header((CharSequence)"Content-Length", this.contentLength)).body(this.body)).build();
    }
}

