/*
 * Decompiled with CFR 0.152.
 */
package com.hotels.styx.api.io;

import com.google.common.base.Throwables;
import com.hotels.styx.api.Resource;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.net.URL;

public class ClasspathResource
implements Resource {
    public static final String CLASSPATH_SCHEME = "classpath:";
    private final String path;
    private final ClassLoader classLoader;

    public ClasspathResource(String path, Class<?> clazz) {
        this(path, clazz.getClassLoader());
    }

    public ClasspathResource(String path, ClassLoader classLoader) {
        this.path = ClasspathResource.stripInitialSlash(path.replace(CLASSPATH_SCHEME, ""));
        this.classLoader = classLoader;
    }

    private static String stripInitialSlash(String path) {
        if (path.startsWith("/")) {
            return path.substring(1);
        }
        return path;
    }

    @Override
    public String path() {
        return this.path;
    }

    @Override
    public URL url() {
        URL url = this.classLoader.getResource(this.path);
        if (url == null) {
            throw Throwables.propagate((Throwable)new FileNotFoundException(this.path));
        }
        return url;
    }

    @Override
    public String absolutePath() {
        return this.url().getFile();
    }

    @Override
    public InputStream inputStream() throws FileNotFoundException {
        InputStream stream = this.classLoader.getResourceAsStream(this.path);
        if (stream == null) {
            throw new FileNotFoundException(CLASSPATH_SCHEME + this.path);
        }
        return stream;
    }

    @Override
    public ClassLoader classLoader() {
        return this.classLoader;
    }

    public String toString() {
        return CLASSPATH_SCHEME + this.path();
    }
}

