/*
 * Decompiled with CFR 0.152.
 */
package com.hotels.styx.api.io;

import com.google.common.base.Throwables;
import com.google.common.collect.Iterators;
import com.hotels.styx.api.Resource;
import com.hotels.styx.api.io.DelegatingResourceIteratorFactory;
import com.hotels.styx.api.io.ResourceIndex;
import java.io.IOException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Spliterators;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public class ClasspathResourceIndex
implements ResourceIndex {
    private final ClassLoader classLoader;

    public ClasspathResourceIndex(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    @Override
    public Iterable<Resource> list(String path, String suffix) {
        String classpath = path.replace("classpath:", "");
        DelegatingResourceIteratorFactory resourceIteratorFactory = new DelegatingResourceIteratorFactory();
        try {
            Enumeration<URL> resources = this.classLoader.getResources(classpath);
            return ClasspathResourceIndex.enumerationStream(resources).map(url -> resourceIteratorFactory.createIterator((URL)url, classpath, suffix)).flatMap(ClasspathResourceIndex::iteratorStream).collect(Collectors.toList());
        }
        catch (IOException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    private static <T> Stream<T> enumerationStream(Enumeration<T> enumeration) {
        return ClasspathResourceIndex.iteratorStream(Iterators.forEnumeration(enumeration));
    }

    private static <T> Stream<T> iteratorStream(Iterator<T> iterator) {
        return StreamSupport.stream(Spliterators.spliteratorUnknownSize(iterator, 16), false);
    }
}

