/*
 * Decompiled with CFR 0.152.
 */
package com.hotels.styx.api.io;

import com.google.common.base.Preconditions;
import com.hotels.styx.api.Resource;
import com.hotels.styx.api.io.ResourceIteratorFactory;
import com.hotels.styx.api.io.ZipThenFileResourceIteratorFallback;
import java.net.URL;
import java.util.Iterator;
import java.util.ServiceLoader;

public class DelegatingResourceIteratorFactory
implements ResourceIteratorFactory {
    private final Iterable<ResourceIteratorFactory> delegates = ServiceLoader.load(ResourceIteratorFactory.class);
    private final ResourceIteratorFactory fallback;

    public DelegatingResourceIteratorFactory() {
        this(new ZipThenFileResourceIteratorFallback());
    }

    public DelegatingResourceIteratorFactory(ResourceIteratorFactory fallback) {
        this.fallback = (ResourceIteratorFactory)Preconditions.checkNotNull((Object)fallback);
    }

    @Override
    public boolean isFactoryFor(URL url) {
        for (ResourceIteratorFactory delegate : this.delegates) {
            if (!delegate.isFactoryFor(url)) continue;
            return true;
        }
        return this.fallback.isFactoryFor(url);
    }

    @Override
    public Iterator<Resource> createIterator(URL url, String path, String suffix) {
        for (ResourceIteratorFactory delegate : this.delegates) {
            if (!delegate.isFactoryFor(url)) continue;
            return delegate.createIterator(url, path, suffix);
        }
        if (this.fallback.isFactoryFor(url)) {
            return this.fallback.createIterator(url, path, suffix);
        }
        throw new RuntimeException("Fallback factory cannot handle URL: " + url);
    }
}

