/*
 * Decompiled with CFR 0.152.
 */
package com.hotels.styx.api.io;

import com.google.common.base.Throwables;
import com.hotels.styx.api.Resource;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;

public class FileResource
implements Resource {
    public static final String FILE_SCHEME = "file:";
    private final File root;
    private final File file;

    public FileResource(File file) {
        this(file, file);
    }

    public FileResource(File root, File file) {
        this.root = root;
        this.file = file;
        if (!file.getAbsolutePath().startsWith(root.getAbsolutePath())) {
            throw new IllegalArgumentException(file.getAbsolutePath() + " is not a parent of " + root.getAbsolutePath());
        }
    }

    public FileResource(String path) {
        this(new File(path.replace(FILE_SCHEME, "")));
    }

    @Override
    public String path() {
        if (this.file.equals(this.root)) {
            return this.file.getPath();
        }
        return this.file.getAbsolutePath().substring(this.root.getAbsolutePath().length() + 1);
    }

    @Override
    public URL url() {
        try {
            return this.getFile().toURI().toURL();
        }
        catch (MalformedURLException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    @Override
    public String absolutePath() {
        return this.file.getAbsolutePath();
    }

    @Override
    public InputStream inputStream() throws IOException {
        return new FileInputStream(this.file);
    }

    @Override
    public ClassLoader classLoader() {
        throw new UnsupportedOperationException();
    }

    public File getFile() {
        return this.file;
    }

    public String toString() {
        return this.absolutePath();
    }
}

