/*
 * Decompiled with CFR 0.152.
 */
package com.hotels.styx.api.io;

import com.google.common.collect.FluentIterable;
import com.google.common.io.Files;
import com.hotels.styx.api.Resource;
import com.hotels.styx.api.common.Strings;
import com.hotels.styx.api.io.FileResource;
import java.io.File;
import java.util.Iterator;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.StreamSupport;

public class FileResourceIterator
implements Iterator<Resource> {
    private final Iterator<Resource> resourceIterator;

    public FileResourceIterator(File root, File file, String suffix) {
        File absolutePath = root.toPath().resolve(file.toPath()).toFile();
        FluentIterable children = Files.fileTreeTraverser().postOrderTraversal((Object)absolutePath);
        this.resourceIterator = StreamSupport.stream(children.spliterator(), false).filter(FileResourceIterator.hasSuffix(suffix).or(FileResourceIterator.sameFile(file))).map(FileResourceIterator.fileToResource(file)).iterator();
    }

    private static Predicate<File> sameFile(File file) {
        return input -> input.isFile() && input.getAbsolutePath().equals(file.getAbsolutePath());
    }

    private static Function<File, Resource> fileToResource(File root) {
        return input -> new FileResource(root, (File)input);
    }

    private static Predicate<File> hasSuffix(String suffix) {
        return file -> Strings.hasSuffix(suffix, file.getPath());
    }

    @Override
    public boolean hasNext() {
        return this.resourceIterator.hasNext();
    }

    @Override
    public Resource next() {
        return this.resourceIterator.next();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

