/*
 * Decompiled with CFR 0.152.
 */
package com.hotels.styx.api.io;

import java.io.File;

public final class PackageName {
    public static final String CLASSPATH_SCHEME = "classpath:";
    private final String rawValue;
    private final String value;

    public static PackageName packageName(String value) {
        return new PackageName(value, PackageName.packageNameFrom(value));
    }

    private PackageName(String rawValue, String value) {
        this.rawValue = rawValue;
        this.value = value;
    }

    public String value() {
        return this.value;
    }

    public String asClasspath() {
        return CLASSPATH_SCHEME + this.value.replace('.', '/').replace(File.separatorChar, '/');
    }

    private static String packageNameFrom(String value) {
        return PackageName.isClasspathPath(value) ? PackageName.stripClasspathPrefix(value) : value.replace('/', '.').replace('\\', '.');
    }

    private static boolean isClasspathPath(String path) {
        return path.startsWith(CLASSPATH_SCHEME);
    }

    private static String stripClasspathPrefix(String path) {
        return path.substring(CLASSPATH_SCHEME.length());
    }
}

