/*
 * Decompiled with CFR 0.152.
 */
package com.hotels.styx.api.io;

import com.google.common.base.Preconditions;
import com.hotels.styx.api.Resource;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class ZipResource
implements Resource {
    private final ZipFile jarFile;
    private final ZipEntry jarEntry;

    public ZipResource(ZipFile jarFile, ZipEntry jarEntry) {
        this.jarFile = (ZipFile)Preconditions.checkNotNull((Object)jarFile);
        this.jarEntry = (ZipEntry)Preconditions.checkNotNull((Object)jarEntry);
    }

    @Override
    public String path() {
        return this.jarEntry.getName();
    }

    @Override
    public URL url() {
        return null;
    }

    @Override
    public String absolutePath() {
        return this.jarFile.getName() + "!/" + this.path();
    }

    @Override
    public InputStream inputStream() throws IOException {
        return this.jarFile.getInputStream(this.jarEntry);
    }

    @Override
    public ClassLoader classLoader() {
        throw new UnsupportedOperationException();
    }

    public String toString() {
        return this.absolutePath();
    }
}

