/*
 * Decompiled with CFR 0.152.
 */
package com.hotels.styx.api.io;

import com.hotels.styx.api.Resource;
import com.hotels.styx.api.io.ResourceIteratorFactory;
import com.hotels.styx.api.io.ZipResourceIterator;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.Iterator;

public class ZipResourceIteratorFactory
implements ResourceIteratorFactory {
    @Override
    public boolean isFactoryFor(URL url) {
        return "jar".equals(url.getProtocol());
    }

    @Override
    public Iterator<Resource> createIterator(URL url, String path, String suffix) {
        try {
            String jarPath = ZipResourceIteratorFactory.filePath(url);
            return new ZipResourceIterator(jarPath, path, suffix);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    static String filePath(URL jarUrl) throws UnsupportedEncodingException, MalformedURLException {
        String path = new File(new URL(jarUrl.getFile()).getFile()).getAbsolutePath();
        String pathToJar = path.substring(0, path.lastIndexOf("!"));
        return URLDecoder.decode(pathToJar, "UTF-8");
    }
}

