/*
 * Decompiled with CFR 0.152.
 */
package com.hotels.styx.api.messages;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.hotels.styx.api.HttpCookie;
import com.hotels.styx.api.HttpCookieAttribute;
import com.hotels.styx.api.HttpHeaderNames;
import com.hotels.styx.api.HttpHeaderValues;
import com.hotels.styx.api.HttpHeaders;
import com.hotels.styx.api.HttpMessageSupport;
import com.hotels.styx.api.HttpRequest;
import com.hotels.styx.api.Url;
import com.hotels.styx.api.messages.FullHttpMessage;
import com.hotels.styx.api.messages.HttpMethod;
import com.hotels.styx.api.messages.HttpVersion;
import com.hotels.styx.api.messages.StreamingHttpRequest;
import com.hotels.styx.api.support.CookiesSupport;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.net.InetSocketAddress;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import rx.Observable;

public class FullHttpRequest
implements FullHttpMessage {
    private final Object id;
    private final InetSocketAddress clientAddress;
    private final HttpVersion version;
    private final HttpMethod method;
    private final Url url;
    private final HttpHeaders headers;
    private final boolean secure;
    private final byte[] body;
    private final List<HttpCookie> cookies;

    FullHttpRequest(Builder builder) {
        this.id = builder.id == null ? UUID.randomUUID() : builder.id;
        this.clientAddress = builder.clientAddress;
        this.version = builder.version;
        this.method = builder.method;
        this.url = builder.url;
        this.secure = builder.secure;
        this.headers = builder.headers.build();
        this.body = Objects.requireNonNull(builder.body);
        this.cookies = ImmutableList.copyOf((Collection)builder.cookies);
    }

    public static <T> Builder get(String uri) {
        return new Builder(HttpMethod.GET, uri);
    }

    public static <T> Builder head(String uri) {
        return new Builder(HttpMethod.HEAD, uri);
    }

    public static <T> Builder post(String uri) {
        return new Builder(HttpMethod.POST, uri);
    }

    public static <T> Builder delete(String uri) {
        return new Builder(HttpMethod.DELETE, uri);
    }

    public static <T> Builder put(String uri) {
        return new Builder(HttpMethod.PUT, uri);
    }

    public static <T> Builder patch(String uri) {
        return new Builder(HttpMethod.PATCH, uri);
    }

    @Override
    public HttpVersion version() {
        return this.version;
    }

    @Override
    public HttpHeaders headers() {
        return this.headers;
    }

    @Override
    public List<HttpCookie> cookies() {
        return this.cookies;
    }

    @Override
    public List<String> headers(CharSequence name) {
        return this.headers.getAll(name);
    }

    @Override
    public byte[] body() {
        return (byte[])this.body.clone();
    }

    @Override
    public String bodyAs(Charset charset) {
        return new String(this.body, charset);
    }

    public Object id() {
        return this.id;
    }

    public HttpMethod method() {
        return this.method;
    }

    public Url url() {
        return this.url;
    }

    public String path() {
        return this.url.path();
    }

    public boolean keepAlive() {
        return HttpMessageSupport.keepAlive(this.headers, this.version);
    }

    public boolean isSecure() {
        return this.secure;
    }

    InetSocketAddress clientAddress() {
        return this.clientAddress;
    }

    public Optional<String> queryParam(String name) {
        return this.url.queryParam(name);
    }

    public Iterable<String> queryParams(String name) {
        return this.url.queryParams(name);
    }

    public Map<String, List<String>> queryParams() {
        return this.url.queryParams();
    }

    public Iterable<String> queryParamNames() {
        return this.url.queryParamNames();
    }

    public Builder newBuilder() {
        return new Builder(this);
    }

    public HttpRequest toStreamingRequest() {
        HttpRequest.Builder streamingBuilder = new HttpRequest.Builder(this).clientAddress(this.clientAddress);
        if (this.body.length == 0) {
            return ((HttpRequest.Builder)streamingBuilder.body((Observable<ByteBuf>)Observable.empty())).build();
        }
        return ((HttpRequest.Builder)streamingBuilder.body((Observable<ByteBuf>)Observable.just((Object)Unpooled.copiedBuffer((byte[])this.body)))).build();
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("version", (Object)this.version).add("method", (Object)this.method).add("uri", (Object)this.url).add("headers", (Object)this.headers).add("cookies", this.cookies).add("id", this.id).add("secure", this.secure).toString();
    }

    public static final class Builder {
        private static final InetSocketAddress LOCAL_HOST = InetSocketAddress.createUnresolved("127.0.0.1", 0);
        private Object id;
        private HttpMethod method = HttpMethod.GET;
        private InetSocketAddress clientAddress = LOCAL_HOST;
        private boolean validate = true;
        private Url url;
        private boolean secure;
        private HttpHeaders.Builder headers;
        private HttpVersion version = HttpVersion.HTTP_1_1;
        private byte[] body;
        private final List<HttpCookie> cookies;

        public Builder() {
            this.url = Url.Builder.url("/").build();
            this.headers = new HttpHeaders.Builder();
            this.body = new byte[0];
            this.cookies = new ArrayList<HttpCookie>();
        }

        public Builder(HttpMethod method, String uri) {
            this();
            this.method = Objects.requireNonNull(method);
            this.url = Url.Builder.url(uri).build();
            this.secure = this.url.isSecure();
        }

        public Builder(HttpRequest request, byte[] body) {
            this.id = request.id();
            this.method = HttpMethod.httpMethod(request.method().name());
            this.clientAddress = request.clientAddress();
            this.url = request.url();
            this.secure = request.isSecure();
            this.version = HttpVersion.httpVersion(request.version().toString());
            this.headers = request.headers().newBuilder();
            this.body = body;
            this.cookies = new ArrayList<HttpCookie>((Collection<HttpCookie>)request.cookies());
        }

        public Builder(StreamingHttpRequest request, byte[] body) {
            this.id = request.id();
            this.method = request.method();
            this.clientAddress = request.clientAddress();
            this.url = request.url();
            this.secure = request.isSecure();
            this.version = request.version();
            this.headers = request.headers().newBuilder();
            this.body = body;
            this.cookies = new ArrayList<HttpCookie>(request.cookies());
        }

        Builder(FullHttpRequest request) {
            this.id = request.id();
            this.method = request.method();
            this.clientAddress = request.clientAddress;
            this.url = request.url();
            this.secure = request.isSecure();
            this.version = request.version();
            this.headers = request.headers().newBuilder();
            this.body = request.body();
            this.cookies = new ArrayList<HttpCookie>(request.cookies());
        }

        public Builder uri(String uri) {
            return this.url(Url.Builder.url(uri).build());
        }

        public Builder body(String content, Charset charset) {
            return this.body(content, charset, true);
        }

        public Builder body(String content, Charset charset, boolean setContentLength) {
            Objects.requireNonNull(charset, "Charset is not provided.");
            String sanitised = content == null ? "" : content;
            return this.body(sanitised.getBytes(charset), setContentLength);
        }

        public Builder body(byte[] content, boolean setContentLength) {
            byte[] byArray = this.body = content != null ? (byte[])content.clone() : new byte[]{};
            if (setContentLength) {
                this.header(HttpHeaderNames.CONTENT_LENGTH, this.body.length);
            }
            return this;
        }

        public Builder id(Object id) {
            this.id = id;
            return this;
        }

        public Builder header(CharSequence name, Object value) {
            Builder.checkNotCookie(name);
            this.headers.set(name, value);
            return this;
        }

        public Builder headers(HttpHeaders headers) {
            this.headers = headers.newBuilder();
            return this;
        }

        public Builder addHeader(CharSequence name, Object value) {
            Builder.checkNotCookie(name);
            this.headers.add(name, value);
            return this;
        }

        public Builder removeHeader(CharSequence name) {
            this.headers.remove(name);
            return this;
        }

        public Builder url(Url url) {
            this.url = url;
            this.secure = url.isSecure();
            return this;
        }

        public Builder version(HttpVersion version) {
            this.version = Objects.requireNonNull(version);
            return this;
        }

        public Builder method(HttpMethod method) {
            this.method = Objects.requireNonNull(method);
            return this;
        }

        public Builder addCookie(HttpCookie cookie) {
            this.cookies.add((HttpCookie)Preconditions.checkNotNull((Object)cookie));
            return this;
        }

        public Builder addCookie(String name, String value) {
            return this.addCookie(HttpCookie.cookie(name, value, new HttpCookieAttribute[0]));
        }

        public Builder removeCookie(String name) {
            CookiesSupport.findCookie(this.cookies, name).ifPresent(this.cookies::remove);
            return this;
        }

        public Builder secure(boolean secure) {
            this.secure = secure;
            return this;
        }

        public Builder enableKeepAlive() {
            return this.header(HttpHeaderNames.CONNECTION, HttpHeaderValues.KEEP_ALIVE);
        }

        public Builder disableValidation() {
            this.validate = false;
            return this;
        }

        public FullHttpRequest build() {
            if (this.validate) {
                this.ensureContentLengthIsValid();
                this.ensureMethodIsValid();
                this.setHostHeader();
            }
            return new FullHttpRequest(this);
        }

        private void setHostHeader() {
            this.url.authority().ifPresent(authority -> this.header(HttpHeaderNames.HOST, authority.hostAndPort()));
        }

        private void ensureMethodIsValid() {
            Preconditions.checkArgument((boolean)this.isMethodValid(), (String)"Unrecognised HTTP method=%s", (Object[])new Object[]{this.method});
        }

        private static void checkNotCookie(CharSequence name) {
            Preconditions.checkArgument((!CookiesSupport.isCookieHeader(name.toString()) ? 1 : 0) != 0, (Object)"Cookies must be set with addCookie method");
        }

        private boolean isMethodValid() {
            return HttpMethod.METHODS.contains(this.method);
        }

        private void ensureContentLengthIsValid() {
            ImmutableList<String> contentLengths = this.headers.build().getAll(HttpHeaderNames.CONTENT_LENGTH);
            Preconditions.checkArgument((contentLengths.size() <= 1 ? 1 : 0) != 0, (String)"Duplicate Content-Length found. %s", (Object[])new Object[]{contentLengths});
            if (contentLengths.size() == 1) {
                Preconditions.checkArgument((boolean)Builder.isInteger((String)contentLengths.get(0)), (String)"Invalid Content-Length found. %s", (Object[])new Object[]{contentLengths.get(0)});
            }
        }

        private static boolean isInteger(String contentLength) {
            try {
                Integer.parseInt(contentLength);
                return true;
            }
            catch (NumberFormatException e) {
                return false;
            }
        }
    }
}

