/*
 * Decompiled with CFR 0.152.
 */
package com.hotels.styx.api.messages;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.hotels.styx.api.HttpCookie;
import com.hotels.styx.api.HttpCookieAttribute;
import com.hotels.styx.api.HttpHeaderNames;
import com.hotels.styx.api.HttpHeaderValues;
import com.hotels.styx.api.HttpHeaders;
import com.hotels.styx.api.HttpResponse;
import com.hotels.styx.api.messages.FullHttpMessage;
import com.hotels.styx.api.messages.HttpResponseStatus;
import com.hotels.styx.api.messages.HttpVersion;
import com.hotels.styx.api.messages.StreamingHttpResponse;
import com.hotels.styx.api.support.CookiesSupport;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import rx.Observable;

public class FullHttpResponse
implements FullHttpMessage {
    private final HttpVersion version;
    private final HttpResponseStatus status;
    private final HttpHeaders headers;
    private final byte[] body;
    private final List<HttpCookie> cookies;

    FullHttpResponse(Builder builder) {
        this.version = builder.version;
        this.status = builder.status;
        this.headers = builder.headers.build();
        this.body = Objects.requireNonNull(builder.body);
        this.cookies = ImmutableList.copyOf((Collection)builder.cookies);
    }

    public static Builder response() {
        return new Builder();
    }

    public static Builder response(HttpResponseStatus status) {
        return new Builder(status);
    }

    @Override
    public Optional<String> header(CharSequence name) {
        return this.headers.get(name);
    }

    @Override
    public List<String> headers(CharSequence name) {
        return this.headers.getAll(name);
    }

    @Override
    public HttpHeaders headers() {
        return this.headers;
    }

    @Override
    public List<HttpCookie> cookies() {
        return this.cookies;
    }

    @Override
    public byte[] body() {
        return (byte[])this.body.clone();
    }

    @Override
    public String bodyAs(Charset charset) {
        return new String(this.body, charset);
    }

    @Override
    public HttpVersion version() {
        return this.version;
    }

    public Builder newBuilder() {
        return new Builder(this);
    }

    public HttpResponseStatus status() {
        return this.status;
    }

    public boolean isRedirect() {
        return this.status.code() >= 300 && this.status.code() < 400;
    }

    public HttpResponse toStreamingResponse() {
        if (this.body.length == 0) {
            return new HttpResponse.Builder(this, (Observable<ByteBuf>)Observable.empty()).build();
        }
        return new HttpResponse.Builder(this, (Observable<ByteBuf>)Observable.just((Object)Unpooled.copiedBuffer((byte[])this.body))).build();
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("version", (Object)this.version).add("status", (Object)this.status).add("headers", (Object)this.headers).add("cookies", this.cookies).toString();
    }

    public int hashCode() {
        return Objects.hash(this.version, this.status, this.headers, this.cookies);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        FullHttpResponse other = (FullHttpResponse)obj;
        return Objects.equals(this.version, other.version) && Objects.equals(this.status, other.status) && Objects.equals(this.headers, other.headers) && Objects.equals(this.cookies, other.cookies);
    }

    public static final class Builder {
        private HttpResponseStatus status = HttpResponseStatus.OK;
        private HttpHeaders.Builder headers;
        private HttpVersion version = HttpVersion.HTTP_1_1;
        private boolean validate = true;
        private byte[] body;
        private final List<HttpCookie> cookies;

        public Builder() {
            this.headers = new HttpHeaders.Builder();
            this.body = new byte[0];
            this.cookies = new ArrayList<HttpCookie>();
        }

        public Builder(HttpResponseStatus status) {
            this();
            this.status = status;
        }

        public Builder(FullHttpResponse response) {
            this.status = response.status();
            this.version = response.version();
            this.headers = response.headers().newBuilder();
            this.body = response.body();
            this.cookies = new ArrayList<HttpCookie>(response.cookies());
        }

        public Builder(HttpResponse response, byte[] encodedBody) {
            this.status = HttpResponseStatus.statusWithCode(response.status().code());
            this.version = HttpVersion.httpVersion(response.version().toString());
            this.headers = response.headers().newBuilder();
            this.body = encodedBody;
            this.cookies = new ArrayList<HttpCookie>((Collection<HttpCookie>)response.cookies());
        }

        public Builder(StreamingHttpResponse response, byte[] decoded) {
            this.status = response.status();
            this.version = response.version();
            this.headers = response.headers().newBuilder();
            this.body = decoded;
            this.cookies = new ArrayList<HttpCookie>(response.cookies());
        }

        public Builder status(HttpResponseStatus status) {
            this.status = status;
            return this;
        }

        public Builder body(String content, Charset charset) {
            return this.body(content, charset, true);
        }

        public Builder body(String content, Charset charset, boolean setContentLength) {
            Objects.requireNonNull(charset, "Charset is not provided.");
            String sanitised = content == null ? "" : content;
            return this.body(sanitised.getBytes(charset), setContentLength);
        }

        public Builder body(byte[] content, boolean setContentLength) {
            byte[] byArray = this.body = content == null ? new byte[]{} : (byte[])content.clone();
            if (setContentLength) {
                this.header(HttpHeaderNames.CONTENT_LENGTH, this.body.length);
            }
            return this;
        }

        public Builder version(HttpVersion version) {
            this.version = Objects.requireNonNull(version);
            return this;
        }

        public Builder disableCaching() {
            this.header("Pragma", "no-cache");
            this.header("Expires", "Mon, 1 Jan 2007 08:00:00 GMT");
            this.header("Cache-Control", "no-cache,must-revalidate,no-store");
            return this;
        }

        public Builder setChunked() {
            this.headers.add(HttpHeaderNames.TRANSFER_ENCODING, HttpHeaderValues.CHUNKED);
            this.headers.remove(HttpHeaderNames.CONTENT_LENGTH);
            return this;
        }

        public Builder addCookie(HttpCookie cookie) {
            this.cookies.add(Objects.requireNonNull(cookie));
            return this;
        }

        public Builder addCookie(String name, String value) {
            return this.addCookie(HttpCookie.cookie(name, value, new HttpCookieAttribute[0]));
        }

        public Builder removeCookie(String name) {
            CookiesSupport.findCookie(this.cookies, name).ifPresent(this.cookies::remove);
            return this;
        }

        public Builder header(CharSequence name, Object value) {
            this.headers.set(name, value);
            return this;
        }

        public Builder addHeader(CharSequence name, Object value) {
            this.headers.add(name, value);
            return this;
        }

        public Builder removeHeader(CharSequence name) {
            this.headers.remove(name);
            return this;
        }

        public Builder headers(HttpHeaders headers) {
            this.headers = headers.newBuilder();
            return this;
        }

        public Builder disableValidation() {
            this.validate = false;
            return this;
        }

        public FullHttpResponse build() {
            if (this.validate) {
                this.ensureContentLengthIsValid();
            }
            return new FullHttpResponse(this);
        }

        Builder ensureContentLengthIsValid() {
            ImmutableList<String> contentLengths = this.headers.build().getAll(HttpHeaderNames.CONTENT_LENGTH);
            Preconditions.checkArgument((contentLengths.size() <= 1 ? 1 : 0) != 0, (String)"Duplicate Content-Length found. %s", (Object[])new Object[]{contentLengths});
            if (contentLengths.size() == 1) {
                Preconditions.checkArgument((boolean)Builder.isInteger((String)contentLengths.get(0)), (String)"Invalid Content-Length found. %s", (Object[])new Object[]{contentLengths.get(0)});
            }
            return this;
        }

        private static boolean isInteger(String contentLength) {
            try {
                Integer.parseInt(contentLength);
                return true;
            }
            catch (NumberFormatException e) {
                return false;
            }
        }
    }
}

