/*
 * Decompiled with CFR 0.152.
 */
package com.hotels.styx.api.messages;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;

public final class HttpMethod {
    public static final HttpMethod OPTIONS = new HttpMethod("OPTIONS");
    public static final HttpMethod GET = new HttpMethod("GET");
    public static final HttpMethod HEAD = new HttpMethod("HEAD");
    public static final HttpMethod POST = new HttpMethod("POST");
    public static final HttpMethod PUT = new HttpMethod("PUT");
    public static final HttpMethod PATCH = new HttpMethod("PATCH");
    public static final HttpMethod DELETE = new HttpMethod("DELETE");
    public static final HttpMethod TRACE = new HttpMethod("TRACE");
    public static final HttpMethod CONNECT = new HttpMethod("CONNECT");
    public static final Set<HttpMethod> METHODS = ImmutableSet.of((Object)OPTIONS, (Object)GET, (Object)HEAD, (Object)POST, (Object)PUT, (Object)PATCH, (Object[])new HttpMethod[]{DELETE, TRACE, CONNECT});
    private static final Map<String, HttpMethod> METHODS_BY_NAME = METHODS.stream().collect(Collectors.toMap(HttpMethod::name, Function.identity()));
    private final String name;

    private HttpMethod(String name) {
        this.name = name;
    }

    public static HttpMethod httpMethod(String name) {
        Preconditions.checkArgument((boolean)METHODS_BY_NAME.containsKey(name), (String)"No such HTTP method %s", (Object[])new Object[]{name});
        return METHODS_BY_NAME.get(name);
    }

    public String name() {
        return this.name;
    }

    public String toString() {
        return this.name;
    }
}

