/*
 * Decompiled with CFR 0.152.
 */
package com.hotels.styx.api.messages;

import com.hotels.styx.api.HttpCookie;
import com.hotels.styx.api.HttpHeaderNames;
import com.hotels.styx.api.HttpHeaders;
import com.hotels.styx.api.HttpMessageSupport;
import com.hotels.styx.api.messages.HttpVersion;
import com.hotels.styx.api.support.CookiesSupport;
import io.netty.buffer.ByteBuf;
import java.util.List;
import java.util.Optional;
import rx.Observable;

public interface StreamingHttpMessage {
    public HttpVersion version();

    public HttpHeaders headers();

    public List<HttpCookie> cookies();

    public Observable<ByteBuf> body();

    default public Optional<String> header(CharSequence name) {
        return this.headers().get(name);
    }

    default public List<String> headers(CharSequence name) {
        return this.headers().getAll(name);
    }

    default public Optional<HttpCookie> cookie(String name) {
        return CookiesSupport.findCookie(this.cookies(), name);
    }

    default public Optional<Integer> contentLength() {
        return this.header(HttpHeaderNames.CONTENT_LENGTH).map(Integer::valueOf);
    }

    default public Optional<String> contentType() {
        return this.header(HttpHeaderNames.CONTENT_TYPE);
    }

    default public boolean chunked() {
        return HttpMessageSupport.chunked(this.headers());
    }
}

