/*
 * Decompiled with CFR 0.152.
 */
package com.hotels.styx.api.messages;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.hotels.styx.api.ContentOverflowException;
import com.hotels.styx.api.FlowControlDisableOperator;
import com.hotels.styx.api.HttpCookie;
import com.hotels.styx.api.HttpCookieAttribute;
import com.hotels.styx.api.HttpHeaderNames;
import com.hotels.styx.api.HttpHeaderValues;
import com.hotels.styx.api.HttpHeaders;
import com.hotels.styx.api.HttpResponse;
import com.hotels.styx.api.messages.FullHttpResponse;
import com.hotels.styx.api.messages.HttpResponseStatus;
import com.hotels.styx.api.messages.HttpVersion;
import com.hotels.styx.api.messages.StreamingHttpMessage;
import com.hotels.styx.api.support.CookiesSupport;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.netty.buffer.CompositeByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.util.ReferenceCountUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import rx.Observable;

public class StreamingHttpResponse
implements StreamingHttpMessage {
    private final HttpVersion version;
    private final HttpResponseStatus status;
    private final HttpHeaders headers;
    private final Observable<ByteBuf> body;
    private final List<HttpCookie> cookies;

    StreamingHttpResponse(Builder builder) {
        this.version = builder.version;
        this.status = builder.status;
        this.headers = builder.headers.build();
        this.body = builder.body;
        this.cookies = ImmutableList.copyOf((Collection)builder.cookies);
    }

    public static Builder response() {
        return new Builder();
    }

    public static Builder response(HttpResponseStatus status) {
        return new Builder(status);
    }

    public static Builder response(HttpResponseStatus status, Observable<ByteBuf> body) {
        return new Builder(status).body(body);
    }

    @Override
    public Optional<String> header(CharSequence name) {
        return this.headers.get(name);
    }

    @Override
    public List<String> headers(CharSequence name) {
        return this.headers.getAll(name);
    }

    @Override
    public HttpHeaders headers() {
        return this.headers;
    }

    @Override
    public List<HttpCookie> cookies() {
        return this.cookies;
    }

    @Override
    public Observable<ByteBuf> body() {
        return this.body;
    }

    @Override
    public HttpVersion version() {
        return this.version;
    }

    public Builder newBuilder() {
        return new Builder(this);
    }

    public HttpResponseStatus status() {
        return this.status;
    }

    public boolean isRedirect() {
        return this.status.code() >= 300 && this.status.code() < 400;
    }

    public Observable<FullHttpResponse> toFullHttpResponse(int maxContentBytes) {
        CompositeByteBuf byteBufs = Unpooled.compositeBuffer();
        return this.body.lift(FlowControlDisableOperator.disableFlowControl()).doOnError(e -> byteBufs.release()).collect(() -> byteBufs, (composite, part) -> {
            long newSize = composite.readableBytes() + part.readableBytes();
            if (newSize > (long)maxContentBytes) {
                ReferenceCountUtil.release((Object)composite);
                ReferenceCountUtil.release((Object)part);
                throw new ContentOverflowException(String.format("Maximum content size exceeded. Maximum size allowed is %d bytes.", maxContentBytes));
            }
            composite.addComponent(part);
            composite.writerIndex(composite.writerIndex() + part.readableBytes());
        }).map(StreamingHttpResponse::decodeAndRelease).map(decoded -> new FullHttpResponse.Builder(this, (byte[])decoded).build());
    }

    private static byte[] decodeAndRelease(CompositeByteBuf aggregate) {
        try {
            byte[] byArray = ByteBufUtil.getBytes((ByteBuf)aggregate);
            return byArray;
        }
        finally {
            aggregate.release();
        }
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("version", (Object)this.version).add("status", (Object)this.status).add("headers", (Object)this.headers).add("cookies", this.cookies).toString();
    }

    public int hashCode() {
        return Objects.hash(this.version, this.status, this.headers, this.cookies);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        StreamingHttpResponse other = (StreamingHttpResponse)obj;
        return Objects.equals(this.version, other.version) && Objects.equals(this.status, other.status) && Objects.equals(this.headers, other.headers) && Objects.equals(this.cookies, other.cookies);
    }

    public static final class Builder {
        private HttpResponseStatus status = HttpResponseStatus.OK;
        private HttpHeaders.Builder headers;
        private HttpVersion version = HttpVersion.HTTP_1_1;
        private boolean validate = true;
        private Observable<ByteBuf> body;
        private final List<HttpCookie> cookies;

        public Builder() {
            this.headers = new HttpHeaders.Builder();
            this.body = Observable.empty();
            this.cookies = new ArrayList<HttpCookie>();
        }

        public Builder(HttpResponseStatus status) {
            this();
            this.status = status;
        }

        public Builder(StreamingHttpResponse response) {
            this.status = response.status();
            this.version = response.version();
            this.headers = response.headers().newBuilder();
            this.body = response.body();
            this.cookies = new ArrayList<HttpCookie>(response.cookies());
        }

        public Builder(HttpResponse response, Observable<ByteBuf> decoded) {
            this.status = HttpResponseStatus.statusWithCode(response.status().code());
            this.version = HttpVersion.httpVersion(response.version().toString());
            this.headers = response.headers().newBuilder();
            this.body = decoded;
            this.cookies = new ArrayList<HttpCookie>((Collection<HttpCookie>)response.cookies());
        }

        public Builder status(HttpResponseStatus status) {
            this.status = status;
            return this;
        }

        public Builder body(Observable<ByteBuf> content) {
            this.body = content;
            return this;
        }

        public Builder version(HttpVersion version) {
            this.version = Objects.requireNonNull(version);
            return this;
        }

        public Builder disableCaching() {
            this.header("Pragma", "no-cache");
            this.header("Expires", "Mon, 1 Jan 2007 08:00:00 GMT");
            this.header("Cache-Control", "no-cache,must-revalidate,no-store");
            return this;
        }

        public Builder setChunked() {
            this.headers.add(HttpHeaderNames.TRANSFER_ENCODING, HttpHeaderValues.CHUNKED);
            this.headers.remove(HttpHeaderNames.CONTENT_LENGTH);
            return this;
        }

        public Builder addCookie(HttpCookie cookie) {
            this.cookies.add((HttpCookie)Preconditions.checkNotNull((Object)cookie));
            return this;
        }

        public Builder addCookie(String name, String value) {
            return this.addCookie(HttpCookie.cookie(name, value, new HttpCookieAttribute[0]));
        }

        public Builder removeCookie(String name) {
            CookiesSupport.findCookie(this.cookies, name).ifPresent(this.cookies::remove);
            return this;
        }

        public Builder header(CharSequence name, Object value) {
            this.headers.set(name, value);
            return this;
        }

        public Builder addHeader(CharSequence name, Object value) {
            this.headers.add(name, value);
            return this;
        }

        public Builder removeHeader(CharSequence name) {
            this.headers.remove(name);
            return this;
        }

        public Builder headers(HttpHeaders headers) {
            this.headers = headers.newBuilder();
            return this;
        }

        public Builder disableValidation() {
            this.validate = false;
            return this;
        }

        public StreamingHttpResponse build() {
            if (this.validate) {
                this.ensureContentLengthIsValid();
            }
            return new StreamingHttpResponse(this);
        }

        Builder ensureContentLengthIsValid() {
            ImmutableList<String> contentLengths = this.headers.build().getAll(HttpHeaderNames.CONTENT_LENGTH);
            Preconditions.checkArgument((contentLengths.size() <= 1 ? 1 : 0) != 0, (String)"Duplicate Content-Length found. %s", (Object[])new Object[]{contentLengths});
            if (contentLengths.size() == 1) {
                Preconditions.checkArgument((boolean)Builder.isInteger((String)contentLengths.get(0)), (String)"Invalid Content-Length found. %s", (Object[])new Object[]{contentLengths.get(0)});
            }
            return this;
        }

        private static boolean isInteger(String contentLength) {
            try {
                Integer.parseInt(contentLength);
                return true;
            }
            catch (NumberFormatException e) {
                return false;
            }
        }
    }
}

