/*
 * Decompiled with CFR 0.152.
 */
package com.hotels.styx.api.metrics;

import com.hotels.styx.api.HttpRequest;
import com.hotels.styx.api.HttpResponse;
import com.hotels.styx.api.metrics.HttpErrorStatusListener;
import io.netty.handler.codec.http.HttpResponseStatus;
import java.util.ArrayList;
import java.util.List;

class CompositeHttpErrorStatusListener
implements HttpErrorStatusListener {
    private final List<HttpErrorStatusListener> listeners;

    public CompositeHttpErrorStatusListener(List<HttpErrorStatusListener> listeners) {
        this.listeners = new ArrayList<HttpErrorStatusListener>(listeners);
    }

    @Override
    public void proxyErrorOccurred(Throwable cause) {
        this.listeners.forEach(listener -> listener.proxyErrorOccurred(cause));
    }

    @Override
    public void proxyWriteFailure(HttpRequest request, HttpResponse response, Throwable cause) {
        this.listeners.forEach(listener -> listener.proxyWriteFailure(request, response, cause));
    }

    @Override
    public void proxyingFailure(HttpRequest request, HttpResponse response, Throwable cause) {
        this.listeners.forEach(listener -> listener.proxyingFailure(request, response, cause));
    }

    @Override
    public void proxyErrorOccurred(HttpResponseStatus status, Throwable cause) {
        this.listeners.forEach(listener -> listener.proxyErrorOccurred(status, cause));
    }

    @Override
    public void proxyErrorOccurred(HttpRequest request, HttpResponseStatus status, Throwable cause) {
        this.listeners.forEach(listener -> listener.proxyErrorOccurred(request, status, cause));
    }
}

