/*
 * Decompiled with CFR 0.152.
 */
package com.hotels.styx.api.metrics;

import com.hotels.styx.api.HttpRequest;
import com.hotels.styx.api.HttpResponse;
import com.hotels.styx.api.metrics.HttpErrorStatusListener;
import io.netty.handler.codec.http.HttpResponseStatus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpErrorStatusCauseLogger
implements HttpErrorStatusListener {
    private static final Logger LOG = LoggerFactory.getLogger(HttpErrorStatusCauseLogger.class);

    @Override
    public void proxyErrorOccurred(HttpResponseStatus status, Throwable cause) {
        if (status.code() > 500) {
            LOG.error("Failure status=\"{}\", exception=\"{}\"", (Object)status, (Object)HttpErrorStatusCauseLogger.withoutStackTrace(cause));
        } else {
            LOG.error("Failure status=\"{}\"", (Object)status, (Object)cause);
        }
    }

    @Override
    public void proxyErrorOccurred(HttpRequest request, HttpResponseStatus status, Throwable cause) {
        if (status.code() == 500) {
            LOG.error("Failure status=\"{}\" during request={}", new Object[]{status, request, cause});
        } else {
            this.proxyErrorOccurred(status, cause);
        }
    }

    @Override
    public void proxyErrorOccurred(Throwable cause) {
        LOG.error("Error occurred during proxying", cause);
    }

    @Override
    public void proxyWriteFailure(HttpRequest request, HttpResponse response, Throwable cause) {
        LOG.error("Error writing response. request={}, response={}, cause={}", new Object[]{request, response, cause});
    }

    @Override
    public void proxyingFailure(HttpRequest request, HttpResponse response, Throwable cause) {
        LOG.error("Error proxying request. request={} response={} cause={}", new Object[]{request, response, cause});
    }

    private static String withoutStackTrace(Throwable cause) {
        StringBuilder builder = new StringBuilder(cause.toString());
        Throwable head = cause;
        while ((head = head.getCause()) != null) {
            builder.append(", cause=").append('\"').append(head).append('\"');
        }
        return builder.toString();
    }
}

