/*
 * Decompiled with CFR 0.152.
 */
package com.hotels.styx.api.metrics;

import com.codahale.metrics.Counter;
import com.google.common.base.Preconditions;
import com.hotels.styx.api.HttpRequest;
import com.hotels.styx.api.HttpResponse;
import com.hotels.styx.api.metrics.HttpErrorStatusListener;
import com.hotels.styx.api.metrics.MetricRegistry;
import com.hotels.styx.api.plugins.spi.PluginException;
import io.netty.handler.codec.http.HttpResponseStatus;

public class HttpErrorStatusMetrics
implements HttpErrorStatusListener {
    private final MetricRegistry metricRegistry;

    public HttpErrorStatusMetrics(MetricRegistry metricRegistry) {
        this.metricRegistry = (MetricRegistry)Preconditions.checkNotNull((Object)metricRegistry);
    }

    @Override
    public void proxyErrorOccurred(HttpResponseStatus status, Throwable cause) {
        this.record(status);
        if (HttpErrorStatusMetrics.isError(status)) {
            this.incrementExceptionCounter(cause, status);
        }
    }

    @Override
    public void proxyErrorOccurred(Throwable cause) {
        this.incrementExceptionCounter(cause);
    }

    @Override
    public void proxyErrorOccurred(HttpRequest request, HttpResponseStatus status, Throwable cause) {
        this.proxyErrorOccurred(status, cause);
    }

    @Override
    public void proxyWriteFailure(HttpRequest request, HttpResponse response, Throwable cause) {
        this.incrementExceptionCounter(cause, response.status());
    }

    @Override
    public void proxyingFailure(HttpRequest request, HttpResponse response, Throwable cause) {
        this.incrementExceptionCounter(cause, response.status());
    }

    private void incrementExceptionCounter(Throwable cause) {
        this.incrementExceptionCounter(cause, null);
    }

    private void incrementExceptionCounter(Throwable cause, HttpResponseStatus status) {
        if (!(cause instanceof PluginException)) {
            if (HttpResponseStatus.INTERNAL_SERVER_ERROR.equals((Object)status)) {
                this.metricRegistry.meter("styx.errors").mark();
            }
            this.exceptionCounter(cause).inc();
        }
    }

    private Counter exceptionCounter(Throwable exception) {
        return this.metricRegistry.counter("styx.exception." + HttpErrorStatusMetrics.formattedExceptionName(exception.getClass()));
    }

    static String formattedExceptionName(Class<? extends Throwable> type) {
        return type.getName().replace('.', '_');
    }

    private static boolean isError(HttpResponseStatus status) {
        return status.code() >= 400;
    }

    private void record(HttpResponseStatus status) {
        if (HttpErrorStatusMetrics.isError(status)) {
            this.metricRegistry.counter("styx.response.status." + status.code()).inc();
        }
    }
}

