/*
 * Decompiled with CFR 0.152.
 */
package com.hotels.styx.api.metrics;

import com.codahale.metrics.Counter;
import com.codahale.metrics.Gauge;
import com.codahale.metrics.Histogram;
import com.codahale.metrics.Meter;
import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricFilter;
import com.codahale.metrics.MetricRegistryListener;
import com.codahale.metrics.Timer;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.hotels.styx.api.metrics.MetricRegistry;
import java.util.ArrayList;
import java.util.List;
import java.util.SortedMap;
import java.util.SortedSet;

public class ScopedMetricRegistry
implements MetricRegistry {
    private final String scope;
    private final MetricRegistry parent;

    public ScopedMetricRegistry(String scope, MetricRegistry parent) {
        this.scope = (String)Preconditions.checkNotNull((Object)scope);
        this.parent = (MetricRegistry)Preconditions.checkNotNull((Object)parent);
    }

    public static ScopedMetricRegistry scope(String scope, MetricRegistry parent) {
        return new ScopedMetricRegistry(scope, parent);
    }

    @Override
    public MetricRegistry scope(String name) {
        return new ScopedMetricRegistry(name, this);
    }

    public List<String> scopes() {
        ArrayList scopes = Lists.newArrayList();
        if (this.parent instanceof ScopedMetricRegistry) {
            scopes.addAll(((ScopedMetricRegistry)this.parent).scopes());
        }
        scopes.add(this.scope);
        return scopes;
    }

    @Override
    public <T extends Metric> T register(String name, T metric) throws IllegalArgumentException {
        try {
            return this.parent.register(this.scopedName(name), metric);
        }
        catch (IllegalArgumentException e) {
            return metric;
        }
    }

    @Override
    public boolean deregister(String name) {
        return this.parent.deregister(this.scopedName(name));
    }

    @Override
    public Counter counter(String name) {
        return this.parent.counter(this.scopedName(name));
    }

    @Override
    public Histogram histogram(String name) {
        return this.parent.histogram(this.scopedName(name));
    }

    @Override
    public Meter meter(String name) {
        return this.parent.meter(this.scopedName(name));
    }

    @Override
    public Timer timer(String name) {
        return this.parent.timer(this.scopedName(name));
    }

    private String scopedName(String name) {
        return this.scope + "." + name;
    }

    @Override
    public void addListener(MetricRegistryListener listener) {
        this.parent.addListener(listener);
    }

    @Override
    public void removeListener(MetricRegistryListener listener) {
        this.parent.removeListener(listener);
    }

    @Override
    public SortedSet<String> getNames() {
        return this.parent.getNames();
    }

    @Override
    public SortedMap<String, Gauge> getGauges() {
        return this.parent.getGauges();
    }

    @Override
    public SortedMap<String, Gauge> getGauges(MetricFilter filter) {
        return this.parent.getGauges(filter);
    }

    @Override
    public SortedMap<String, Counter> getCounters() {
        return this.parent.getCounters();
    }

    @Override
    public SortedMap<String, Counter> getCounters(MetricFilter filter) {
        return this.parent.getCounters(filter);
    }

    @Override
    public SortedMap<String, Histogram> getHistograms() {
        return this.parent.getHistograms();
    }

    @Override
    public SortedMap<String, Histogram> getHistograms(MetricFilter filter) {
        return this.parent.getHistograms(filter);
    }

    @Override
    public SortedMap<String, Meter> getMeters() {
        return this.parent.getMeters();
    }

    @Override
    public SortedMap<String, Meter> getMeters(MetricFilter filter) {
        return this.parent.getMeters(filter);
    }

    @Override
    public SortedMap<String, Timer> getTimers() {
        return this.parent.getTimers();
    }

    @Override
    public SortedMap<String, Timer> getTimers(MetricFilter filter) {
        return this.parent.getTimers(filter);
    }
}

