/*
 * Decompiled with CFR 0.152.
 */
package com.hotels.styx.api.metrics;

import com.google.common.base.Preconditions;
import com.hotels.styx.api.Clock;
import com.hotels.styx.api.Clocks;
import java.util.concurrent.TimeUnit;
import org.HdrHistogram.AbstractHistogram;
import org.HdrHistogram.Histogram;

public final class SlidingWindowHistogram {
    private static final int DEFAULT_NUMBER_OF_INTERVALS = 10;
    private final Clock clock;
    private final Histogram aggregateHistogram;
    private final IntervalBucket[] window;
    private final int numberOfIntervals;
    private final long intervalDurationMillis;
    private long lastUpdateTime;

    private SlidingWindowHistogram(Builder builder) {
        this.numberOfIntervals = builder.numberOfIntervals;
        this.intervalDurationMillis = builder.intervalDurationMillis;
        this.clock = builder.clock;
        this.aggregateHistogram = new Histogram(builder.lowestDiscernibleValue, builder.highestTrackableValue, builder.numberOfSignificantDigits);
        if (builder.autoResize.booleanValue()) {
            this.aggregateHistogram.setAutoResize(true);
        }
        this.window = new IntervalBucket[this.numberOfIntervals];
        for (int i = 0; i < this.numberOfIntervals; ++i) {
            this.window[i] = new IntervalBucket(this.aggregateHistogram, builder.lowestDiscernibleValue, builder.highestTrackableValue, builder.numberOfSignificantDigits, builder.autoResize);
        }
        this.lastUpdateTime = System.currentTimeMillis();
    }

    public synchronized void recordValue(long msValue) {
        Preconditions.checkArgument((msValue >= 0L ? 1 : 0) != 0, (Object)"Recorded value must be a positive number.");
        long currentTime = this.clock.tickMillis();
        this.purgeOldHistograms(currentTime);
        int bucket = this.bucketFromTime(currentTime);
        this.window[bucket].recordValue(msValue);
        this.lastUpdateTime = currentTime;
    }

    public synchronized double getMean() {
        return this.getAggregateHistogram().getMean();
    }

    public synchronized double getValueAtPercentile(double percentile) {
        return this.getAggregateHistogram().getValueAtPercentile(percentile);
    }

    public synchronized double getStdDeviation() {
        return this.getAggregateHistogram().getStdDeviation();
    }

    public synchronized Histogram copy() {
        return this.getAggregateHistogram().copy();
    }

    public int windowSize() {
        return this.numberOfIntervals;
    }

    public long timeIntervalMs() {
        return this.intervalDurationMillis;
    }

    private Histogram getAggregateHistogram() {
        long currentTime = this.clock.tickMillis();
        this.purgeOldHistograms(currentTime);
        this.aggregateHistograms();
        return this.aggregateHistogram;
    }

    private boolean timePassed(long currentTime) {
        return this.intervalNumber(this.lastUpdateTime) < this.intervalNumber(currentTime);
    }

    private void purgeOldHistograms(long currentTime) {
        if (this.timePassed(currentTime)) {
            long startTime;
            int i = 0;
            for (long t = startTime = Math.min(this.lastUpdateTime + this.intervalDurationMillis, currentTime); i < this.numberOfIntervals && t <= currentTime; ++i, t += this.intervalDurationMillis) {
                int bucket = this.bucketFromTime(t);
                this.window[bucket].reset();
            }
        }
    }

    private int bucketFromTime(long timeMs) {
        return (int)(this.intervalNumber(timeMs) % (long)this.numberOfIntervals);
    }

    private long intervalNumber(long timeMs) {
        return timeMs / this.intervalDurationMillis;
    }

    private void aggregateHistograms() {
        for (int i = 0; i < this.numberOfIntervals; ++i) {
            this.window[i].aggregate();
        }
    }

    public static class Builder {
        private int numberOfIntervals = 10;
        private long intervalDurationMillis = TimeUnit.SECONDS.toMillis(1L);
        private long lowestDiscernibleValue = 1L;
        private long highestTrackableValue = 2L;
        private int numberOfSignificantDigits = 2;
        private Clock clock = Clocks.systemClock();
        private Boolean autoResize = false;

        public Builder numberOfIntervals(int windowSizeIntervals) {
            this.numberOfIntervals = windowSizeIntervals;
            return this;
        }

        public Builder intervalDuration(long intervalDuration, TimeUnit timeUnit) {
            this.intervalDurationMillis = timeUnit.toMillis(intervalDuration);
            return this;
        }

        public Builder lowestDiscernibleValue(long lowestDiscernibleValue) {
            this.lowestDiscernibleValue = lowestDiscernibleValue;
            return this;
        }

        public Builder highestTrackableValue(long highestTrackableValue) {
            this.highestTrackableValue = highestTrackableValue;
            return this;
        }

        public Builder numberOfSignificantDigits(int numberOfSignificantDigits) {
            this.numberOfSignificantDigits = numberOfSignificantDigits;
            return this;
        }

        public Builder clock(Clock clock) {
            this.clock = (Clock)Preconditions.checkNotNull((Object)clock);
            return this;
        }

        public Builder autoResize(Boolean enabled) {
            this.autoResize = enabled;
            return this;
        }

        public SlidingWindowHistogram build() {
            return new SlidingWindowHistogram(this);
        }
    }

    private static enum IntervalState {
        AGGREGATED,
        UPDATED,
        EMPTY;

    }

    private static class IntervalBucket {
        private final Histogram aggregateHistogram;
        private final Histogram intervalHistogram;
        private IntervalState state;

        public IntervalBucket(Histogram aggregateHistogram, long lowestDiscernibleValue, long highestTrackableValue, int numberOfSignificantDigits, Boolean autoResize) {
            this.aggregateHistogram = aggregateHistogram;
            this.intervalHistogram = new Histogram(lowestDiscernibleValue, highestTrackableValue, numberOfSignificantDigits);
            if (autoResize.booleanValue()) {
                this.intervalHistogram.setAutoResize(true);
            }
            this.state = IntervalState.EMPTY;
        }

        public void recordValue(long msValue) {
            this.intervalHistogram.recordValue(msValue);
            if (this.state == IntervalState.AGGREGATED) {
                this.aggregateHistogram.recordValue(msValue);
            } else {
                this.state = IntervalState.UPDATED;
            }
        }

        public void reset() {
            if (this.state == IntervalState.AGGREGATED) {
                this.aggregateHistogram.subtract((AbstractHistogram)this.intervalHistogram);
            }
            this.intervalHistogram.reset();
            this.state = IntervalState.EMPTY;
        }

        public void aggregate() {
            if (this.state == IntervalState.UPDATED) {
                this.aggregateHistogram.add((AbstractHistogram)this.intervalHistogram);
                this.state = IntervalState.AGGREGATED;
            }
        }
    }
}

