/*
 * Decompiled with CFR 0.152.
 */
package com.hotels.styx.api.metrics.codahale;

import com.codahale.metrics.Reservoir;
import com.codahale.metrics.Snapshot;
import com.google.common.base.Preconditions;
import com.hotels.styx.api.Clock;
import com.hotels.styx.api.Clocks;
import com.hotels.styx.api.metrics.SlidingWindowHistogram;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.TimeUnit;
import org.HdrHistogram.Histogram;
import org.HdrHistogram.HistogramIterationValue;

public class SlidingWindowHistogramReservoir
implements Reservoir {
    private final SlidingWindowHistogram histogram;
    private final Clock clock;
    private volatile HistogramSnapshot snapshot;
    private boolean updated = true;
    private long snapshotCreationTime;

    public SlidingWindowHistogramReservoir() {
        this(new SlidingWindowHistogram.Builder().numberOfIntervals(12).intervalDuration(10L, TimeUnit.SECONDS).autoResize(true).build());
    }

    public SlidingWindowHistogramReservoir(SlidingWindowHistogram histogram) {
        this(histogram, Clocks.systemClock());
    }

    public SlidingWindowHistogramReservoir(SlidingWindowHistogram histogram, Clock clock) {
        this.histogram = (SlidingWindowHistogram)Preconditions.checkNotNull((Object)histogram);
        this.clock = (Clock)Preconditions.checkNotNull((Object)clock);
        this.snapshotCreationTime = clock.tickMillis();
    }

    public int size() {
        return this.getSnapshot().size();
    }

    public synchronized void update(long value) {
        this.updated = true;
        this.histogram.recordValue(value);
    }

    public synchronized Snapshot getSnapshot() {
        if (this.updated || this.snapshotExpired(this.clock.tickMillis())) {
            this.snapshot = new HistogramSnapshot(this.histogram);
            this.updated = false;
            this.snapshotCreationTime = this.clock.tickMillis();
        }
        return this.snapshot;
    }

    private boolean snapshotExpired(long currentTime) {
        return currentTime - this.snapshotCreationTime > (long)this.histogram.windowSize() * this.histogram.timeIntervalMs();
    }

    static final class HistogramSnapshot
    extends Snapshot {
        private final Histogram histogram;

        HistogramSnapshot(SlidingWindowHistogram histogram) {
            this.histogram = histogram.copy();
        }

        public double getValue(double quantile) {
            return this.histogram.getValueAtPercentile(quantile * 100.0);
        }

        public long[] getValues() {
            long[] vals = new long[(int)this.histogram.getTotalCount()];
            int i = 0;
            for (HistogramIterationValue value : this.histogram.recordedValues()) {
                long val = value.getValueIteratedTo();
                int j = 0;
                while ((long)j < value.getCountAddedInThisIterationStep()) {
                    vals[i++] = val;
                    ++j;
                }
            }
            if (i != vals.length) {
                throw new IllegalStateException(String.format("Total count was %d but iterating values produced is %d", this.histogram.getTotalCount(), vals.length));
            }
            return vals;
        }

        public int size() {
            return (int)this.histogram.getTotalCount();
        }

        public long getMax() {
            return this.histogram.getMaxValue();
        }

        public double getMean() {
            return this.histogram.getMean();
        }

        public long getMin() {
            return this.histogram.getMinValue();
        }

        public double getStdDev() {
            return this.histogram.getStdDeviation();
        }

        public void dump(OutputStream output) {
            PrintWriter p = new PrintWriter(new OutputStreamWriter(output, StandardCharsets.UTF_8));
            for (HistogramIterationValue value : this.histogram.recordedValues()) {
                int j = 0;
                while ((long)j < value.getCountAddedInThisIterationStep()) {
                    p.printf("%d%n", value.getValueIteratedTo());
                    ++j;
                }
            }
        }
    }
}

