/*
 * Decompiled with CFR 0.152.
 */
package com.hotels.styx.api.netty.exceptions;

import com.hotels.styx.api.client.Origin;
import com.hotels.styx.api.netty.exceptions.IsDeadConnectionException;
import com.hotels.styx.api.netty.exceptions.IsTimeoutException;
import com.hotels.styx.api.netty.exceptions.TransportException;

public class ResponseTimeoutException
extends TransportException
implements IsDeadConnectionException,
IsTimeoutException {
    private final Origin origin;

    public ResponseTimeoutException(Origin origin) {
        super(ResponseTimeoutException.message(origin));
        this.origin = origin;
    }

    public ResponseTimeoutException(Origin origin, Throwable cause) {
        super(ResponseTimeoutException.message(origin), cause);
        this.origin = origin;
    }

    public ResponseTimeoutException(Origin origin, String reason, long bytesReceived, long chunksReceived, long bytesEmitted, long chunksEmitted) {
        super(ResponseTimeoutException.message(origin, reason, bytesReceived, chunksReceived, bytesEmitted, chunksEmitted));
        this.origin = origin;
    }

    public Origin origin() {
        return this.origin;
    }

    private static String message(Origin origin) {
        return String.format("No response from origin. origin=%s.", origin);
    }

    private static String message(Origin origin, String reason, long bytesReceived, long chunksReceived, long bytesEmitted, long chunksEmitted) {
        return String.format("No response from origin. origin=%s, ", origin) + String.format("reason=%s, ", reason) + String.format("bytesReceived=%d, ", bytesReceived) + String.format("chunksReceived=%d, ", chunksReceived) + String.format("bytesEmitted=%d, ", bytesEmitted) + String.format("chunksEmitted=%d", chunksEmitted);
    }
}

