/*
 * Decompiled with CFR 0.152.
 */
package com.hotels.styx.api.netty.exceptions;

import com.hotels.styx.api.client.Origin;
import com.hotels.styx.api.netty.exceptions.TransportException;
import io.netty.channel.Channel;
import java.net.SocketAddress;

public class TransportLostException
extends TransportException {
    private static final String MESSAGE_FORMAT = "Connection to origin lost. origin=\"%s\", remoteAddress=\"%s\".";
    private final SocketAddress address;
    private final Origin origin;

    public TransportLostException(Channel channel, Origin origin) {
        super(String.format("Connection to origin lost. origin=%s, connection=%s", origin, channel.toString()));
        this.address = channel.remoteAddress();
        this.origin = origin;
    }

    public TransportLostException(SocketAddress address, Origin origin) {
        super(String.format(MESSAGE_FORMAT, origin, address));
        this.address = address;
        this.origin = origin;
    }

    public SocketAddress remoteAddress() {
        return this.address;
    }

    public Origin origin() {
        return this.origin;
    }
}

