/*
 * Decompiled with CFR 0.152.
 */
package com.hotels.styx.api.service;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.hotels.styx.api.Id;
import com.hotels.styx.api.Identifiable;
import com.hotels.styx.api.client.ConnectionPool;
import com.hotels.styx.api.client.Origin;
import com.hotels.styx.api.service.ConnectionPoolSettings;
import com.hotels.styx.api.service.HealthCheckConfig;
import com.hotels.styx.api.service.RewriteConfig;
import com.hotels.styx.api.service.StickySessionConfig;
import com.hotels.styx.api.service.TlsSettings;
import java.net.URI;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;

public final class BackendService
implements Identifiable {
    public static final int DEFAULT_RESPONSE_TIMEOUT_MILLIS = 1000;
    private final Id id;
    private final String path;
    private final ConnectionPool.Settings connectionPoolSettings;
    private final Set<Origin> origins;
    private final HealthCheckConfig healthCheckConfig;
    private final StickySessionConfig stickySessionConfig;
    private final List<RewriteConfig> rewrites;
    private final int responseTimeoutMillis;
    private final TlsSettings tlsSettings;

    public static Builder newBackendServiceBuilder() {
        return new Builder();
    }

    public static Builder newBackendServiceBuilder(BackendService backendService) {
        return new Builder(backendService);
    }

    private BackendService(Builder builder) {
        this.id = (Id)Preconditions.checkNotNull((Object)builder.id, (Object)"id");
        this.path = (String)Preconditions.checkNotNull((Object)builder.path, (Object)"path");
        this.connectionPoolSettings = (ConnectionPool.Settings)Preconditions.checkNotNull((Object)builder.connectionPoolSettings);
        this.origins = ImmutableSet.copyOf((Collection)builder.origins);
        this.healthCheckConfig = BackendService.nullIfDisabled(builder.healthCheckConfig);
        this.stickySessionConfig = (StickySessionConfig)Preconditions.checkNotNull((Object)builder.stickySessionConfig);
        this.rewrites = (List)Preconditions.checkNotNull((Object)builder.rewrites);
        this.responseTimeoutMillis = builder.responseTimeoutMillis == 0 ? 1000 : builder.responseTimeoutMillis;
        this.tlsSettings = builder.tlsSettings;
        Origin.checkThatOriginsAreDistinct(this.origins);
        Preconditions.checkArgument((this.responseTimeoutMillis >= 0 ? 1 : 0) != 0, (Object)"Request timeout must be greater than or equal to zero");
    }

    private static HealthCheckConfig nullIfDisabled(HealthCheckConfig healthCheckConfig) {
        return healthCheckConfig != null && healthCheckConfig.isEnabled() ? healthCheckConfig : null;
    }

    @Override
    public Id id() {
        return this.id;
    }

    String idAsString() {
        return this.id.toString();
    }

    public String path() {
        return this.path;
    }

    public Set<Origin> origins() {
        return this.origins;
    }

    public ConnectionPool.Settings connectionPoolConfig() {
        return this.connectionPoolSettings;
    }

    public HealthCheckConfig healthCheckConfig() {
        return this.healthCheckConfig;
    }

    public StickySessionConfig stickySessionConfig() {
        return this.stickySessionConfig;
    }

    public List<RewriteConfig> rewrites() {
        return this.rewrites;
    }

    public int responseTimeoutMillis() {
        return this.responseTimeoutMillis;
    }

    public Optional<TlsSettings> tlsSettings() {
        return Optional.ofNullable(this.tlsSettings);
    }

    private TlsSettings getTlsSettings() {
        return this.tlsSettings().orElse(null);
    }

    public Protocol protocol() {
        if (this.tlsSettings == null) {
            return Protocol.HTTP;
        }
        return Protocol.HTTPS;
    }

    public int hashCode() {
        return Objects.hash(this.id, this.path, this.connectionPoolSettings, this.origins, this.healthCheckConfig, this.stickySessionConfig, this.rewrites, this.responseTimeoutMillis);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        BackendService other = (BackendService)obj;
        return Objects.equals(this.id, other.id) && Objects.equals(this.path, other.path) && Objects.equals(this.connectionPoolSettings, other.connectionPoolSettings) && Objects.equals(this.origins, other.origins) && Objects.equals(this.healthCheckConfig, other.healthCheckConfig) && Objects.equals(this.stickySessionConfig, other.stickySessionConfig) && Objects.equals(this.rewrites, other.rewrites) && Objects.equals(this.tlsSettings, other.tlsSettings) && Objects.equals(this.responseTimeoutMillis, other.responseTimeoutMillis);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("id", (Object)this.id).add("path", (Object)this.path).add("origins", this.origins).add("connectionPoolSettings", (Object)this.connectionPoolSettings).add("healthCheckConfig", (Object)this.healthCheckConfig).add("stickySessionConfig", (Object)this.stickySessionConfig).add("rewrites", this.rewrites).add("tlsSettings", (Object)this.tlsSettings).toString();
    }

    public Builder newCopy() {
        return new Builder(this);
    }

    public static final class Builder {
        private Id id = Id.GENERIC_APP;
        private String path = "/";
        private Set<Origin> origins = Collections.emptySet();
        private ConnectionPool.Settings connectionPoolSettings = ConnectionPoolSettings.defaultConnectionPoolSettings();
        private StickySessionConfig stickySessionConfig = StickySessionConfig.stickySessionDisabled();
        private HealthCheckConfig healthCheckConfig;
        private List<RewriteConfig> rewrites = Collections.emptyList();
        public int responseTimeoutMillis = 1000;
        private TlsSettings tlsSettings;

        public Builder() {
        }

        private Builder(BackendService backendService) {
            this.id = backendService.id;
            this.path = backendService.path;
            this.origins = backendService.origins;
            this.connectionPoolSettings = backendService.connectionPoolSettings;
            this.stickySessionConfig = backendService.stickySessionConfig;
            this.healthCheckConfig = backendService.healthCheckConfig;
            this.rewrites = backendService.rewrites;
            this.responseTimeoutMillis = backendService.responseTimeoutMillis;
            this.tlsSettings = backendService.tlsSettings().orElse(null);
        }

        public Builder id(Id id) {
            this.id = (Id)Preconditions.checkNotNull((Object)id);
            return this;
        }

        public Builder id(String id) {
            return this.id(Id.id(id));
        }

        public Builder path(String path) {
            this.path = this.checkValidPath((String)Preconditions.checkNotNull((Object)path));
            return this;
        }

        private String checkValidPath(String path) {
            try {
                URI.create(path);
                return path;
            }
            catch (Throwable cause) {
                String message = String.format("Invalid path. Path='%s'", path);
                throw new IllegalArgumentException(message, cause);
            }
        }

        public Builder responseTimeoutMillis(int timeout) {
            this.responseTimeoutMillis = timeout;
            return this;
        }

        public Builder origins(Set<Origin> origins) {
            this.origins = (Set)Preconditions.checkNotNull(origins);
            return this;
        }

        Builder https(Optional<TlsSettings> tlsSettings) {
            this.tlsSettings = tlsSettings.orElse(null);
            return this;
        }

        public Builder httpsOld(TlsSettings tlsSettings) {
            this.tlsSettings = tlsSettings;
            return this;
        }

        public Builder https(TlsSettings tlsSettings) {
            this.tlsSettings = tlsSettings;
            return this;
        }

        public Builder origins(Origin ... origins) {
            return this.origins((Set<Origin>)ImmutableSet.copyOf((Object[])origins));
        }

        public Builder rewrites(RewriteConfig ... rewriteConfigs) {
            return this.rewrites(Arrays.asList(rewriteConfigs));
        }

        public Builder rewrites(List<RewriteConfig> rewriteConfigs) {
            this.rewrites = ImmutableList.copyOf(rewriteConfigs);
            return this;
        }

        public Builder connectionPoolConfig(ConnectionPoolSettings connectionPoolSettings) {
            this.connectionPoolSettings = (ConnectionPool.Settings)Preconditions.checkNotNull((Object)connectionPoolSettings);
            return this;
        }

        public Builder connectionPoolConfig(ConnectionPool.Settings connectionPoolSettings) {
            this.connectionPoolSettings = (ConnectionPool.Settings)Preconditions.checkNotNull((Object)connectionPoolSettings);
            return this;
        }

        public Builder stickySessionConfig(StickySessionConfig stickySessionConfig) {
            this.stickySessionConfig = (StickySessionConfig)Preconditions.checkNotNull((Object)stickySessionConfig);
            return this;
        }

        public Builder healthCheckConfig(HealthCheckConfig healthCheckConfig) {
            this.healthCheckConfig = healthCheckConfig;
            return this;
        }

        public BackendService build() {
            return new BackendService(this);
        }
    }

    public static enum Protocol {
        HTTP,
        HTTPS;

    }
}

