/*
 * Decompiled with CFR 0.152.
 */
package com.hotels.styx.api.support;

import com.hotels.styx.api.HttpCookie;
import java.util.Collection;
import java.util.Objects;
import java.util.Optional;

public final class CookiesSupport {
    private CookiesSupport() {
    }

    public static boolean isCookieHeader(String header) {
        return "Set-Cookie".equalsIgnoreCase(header) || "Cookie".equalsIgnoreCase(header);
    }

    public static Optional<HttpCookie> findCookie(Collection<HttpCookie> cookies, String name) {
        Objects.requireNonNull(cookies);
        Objects.requireNonNull(name);
        return cookies.stream().filter(cookie -> name.equals(cookie.name())).findFirst();
    }
}

