/*
 * Decompiled with CFR 0.152.
 */
package com.hotels.styx.api.extension.service;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.hotels.styx.api.Id;
import com.hotels.styx.api.Identifiable;
import com.hotels.styx.api.extension.Origin;
import com.hotels.styx.api.extension.service.ConnectionPoolSettings;
import com.hotels.styx.api.extension.service.HealthCheckConfig;
import com.hotels.styx.api.extension.service.RewriteConfig;
import com.hotels.styx.api.extension.service.StickySessionConfig;
import com.hotels.styx.api.extension.service.TlsSettings;
import java.net.URI;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;

public final class BackendService
implements Identifiable {
    public static final int DEFAULT_RESPONSE_TIMEOUT_MILLIS = 1000;
    public static final int USE_DEFAULT_MAX_HEADER_SIZE = 0;
    private final Id id;
    private final String path;
    private final ConnectionPoolSettings connectionPoolSettings;
    private final Set<Origin> origins;
    private final HealthCheckConfig healthCheckConfig;
    private final StickySessionConfig stickySessionConfig;
    private final List<RewriteConfig> rewrites;
    private final int responseTimeoutMillis;
    private final int maxHeaderSize;
    private final TlsSettings tlsSettings;

    public static Builder newBackendServiceBuilder() {
        return new Builder();
    }

    public static Builder newBackendServiceBuilder(BackendService backendService) {
        return new Builder(backendService);
    }

    private BackendService(Builder builder) {
        this.id = Objects.requireNonNull(builder.id, "id");
        this.path = Objects.requireNonNull(builder.path, "path");
        this.connectionPoolSettings = Objects.requireNonNull(builder.connectionPoolSettings);
        this.origins = ImmutableSet.copyOf((Collection)builder.origins);
        this.healthCheckConfig = BackendService.nullIfDisabled(builder.healthCheckConfig);
        this.stickySessionConfig = Objects.requireNonNull(builder.stickySessionConfig);
        this.rewrites = Objects.requireNonNull(builder.rewrites);
        this.responseTimeoutMillis = builder.responseTimeoutMillis == 0 ? 1000 : builder.responseTimeoutMillis;
        this.tlsSettings = builder.tlsSettings;
        this.maxHeaderSize = builder.maxHeaderSize;
        Origin.checkThatOriginsAreDistinct(this.origins);
        Preconditions.checkArgument((this.responseTimeoutMillis >= 0 ? 1 : 0) != 0, (Object)"Request timeout must be greater than or equal to zero");
    }

    private static HealthCheckConfig nullIfDisabled(HealthCheckConfig healthCheckConfig) {
        return healthCheckConfig != null && healthCheckConfig.isEnabled() ? healthCheckConfig : null;
    }

    @Override
    public Id id() {
        return this.id;
    }

    String idAsString() {
        return this.id.toString();
    }

    public String path() {
        return this.path;
    }

    public Set<Origin> origins() {
        return this.origins;
    }

    public ConnectionPoolSettings connectionPoolConfig() {
        return this.connectionPoolSettings;
    }

    public HealthCheckConfig healthCheckConfig() {
        return this.healthCheckConfig;
    }

    public StickySessionConfig stickySessionConfig() {
        return this.stickySessionConfig;
    }

    public List<RewriteConfig> rewrites() {
        return this.rewrites;
    }

    public int responseTimeoutMillis() {
        return this.responseTimeoutMillis;
    }

    public int maxHeaderSize() {
        return this.maxHeaderSize;
    }

    public Optional<TlsSettings> tlsSettings() {
        return Optional.ofNullable(this.tlsSettings);
    }

    private TlsSettings getTlsSettings() {
        return this.tlsSettings().orElse(null);
    }

    public Protocol protocol() {
        if (this.tlsSettings == null) {
            return Protocol.HTTP;
        }
        return Protocol.HTTPS;
    }

    public int hashCode() {
        return Objects.hash(this.id, this.path, this.connectionPoolSettings, this.origins, this.healthCheckConfig, this.stickySessionConfig, this.rewrites, this.responseTimeoutMillis, this.maxHeaderSize);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        BackendService other = (BackendService)obj;
        return Objects.equals(this.id, other.id) && Objects.equals(this.path, other.path) && Objects.equals(this.connectionPoolSettings, other.connectionPoolSettings) && Objects.equals(this.origins, other.origins) && Objects.equals(this.healthCheckConfig, other.healthCheckConfig) && Objects.equals(this.stickySessionConfig, other.stickySessionConfig) && Objects.equals(this.rewrites, other.rewrites) && Objects.equals(this.tlsSettings, other.tlsSettings) && Objects.equals(this.responseTimeoutMillis, other.responseTimeoutMillis) && Objects.equals(this.maxHeaderSize, other.maxHeaderSize);
    }

    public String toString() {
        return com.google.common.base.Objects.toStringHelper((Object)this).add("id", (Object)this.id).add("path", (Object)this.path).add("origins", this.origins).add("connectionPoolSettings", (Object)this.connectionPoolSettings).add("healthCheckConfig", (Object)this.healthCheckConfig).add("stickySessionConfig", (Object)this.stickySessionConfig).add("rewrites", this.rewrites).add("tlsSettings", (Object)this.tlsSettings).toString();
    }

    public Builder newCopy() {
        return new Builder(this);
    }

    public static final class Builder {
        private Id id = Id.GENERIC_APP;
        private String path = "/";
        private Set<Origin> origins = Collections.emptySet();
        private ConnectionPoolSettings connectionPoolSettings = ConnectionPoolSettings.defaultConnectionPoolSettings();
        private StickySessionConfig stickySessionConfig = StickySessionConfig.stickySessionDisabled();
        private HealthCheckConfig healthCheckConfig;
        private List<RewriteConfig> rewrites = Collections.emptyList();
        private int responseTimeoutMillis = 1000;
        private int maxHeaderSize = 0;
        private TlsSettings tlsSettings;

        public Builder() {
        }

        private Builder(BackendService backendService) {
            this.id = backendService.id;
            this.path = backendService.path;
            this.origins = backendService.origins;
            this.connectionPoolSettings = backendService.connectionPoolSettings;
            this.stickySessionConfig = backendService.stickySessionConfig;
            this.healthCheckConfig = backendService.healthCheckConfig;
            this.rewrites = backendService.rewrites;
            this.responseTimeoutMillis = backendService.responseTimeoutMillis;
            this.maxHeaderSize = backendService.maxHeaderSize;
            this.tlsSettings = backendService.tlsSettings().orElse(null);
        }

        public Builder id(Id id) {
            this.id = Objects.requireNonNull(id);
            return this;
        }

        public Builder id(String id) {
            return this.id(Id.id(id));
        }

        public Builder path(String path) {
            this.path = this.checkValidPath(Objects.requireNonNull(path));
            return this;
        }

        private String checkValidPath(String path) {
            try {
                URI.create(path);
                return path;
            }
            catch (Throwable cause) {
                String message = String.format("Invalid path. Path='%s'", path);
                throw new IllegalArgumentException(message, cause);
            }
        }

        public Builder responseTimeoutMillis(int timeout) {
            this.responseTimeoutMillis = timeout;
            return this;
        }

        public Builder maxHeaderSize(int maxHeaderSize) {
            this.maxHeaderSize = maxHeaderSize;
            return this;
        }

        public Builder origins(Set<Origin> origins) {
            this.origins = Objects.requireNonNull(origins);
            return this;
        }

        Builder https(Optional<TlsSettings> tlsSettings) {
            this.tlsSettings = tlsSettings.orElse(null);
            return this;
        }

        public Builder httpsOld(TlsSettings tlsSettings) {
            this.tlsSettings = tlsSettings;
            return this;
        }

        public Builder https(TlsSettings tlsSettings) {
            this.tlsSettings = tlsSettings;
            return this;
        }

        public Builder origins(Origin ... origins) {
            return this.origins((Set<Origin>)ImmutableSet.copyOf((Object[])origins));
        }

        public Builder rewrites(RewriteConfig ... rewriteConfigs) {
            return this.rewrites(Arrays.asList(rewriteConfigs));
        }

        public Builder rewrites(List<RewriteConfig> rewriteConfigs) {
            this.rewrites = ImmutableList.copyOf(rewriteConfigs);
            return this;
        }

        public Builder connectionPoolConfig(ConnectionPoolSettings connectionPoolSettings) {
            this.connectionPoolSettings = Objects.requireNonNull(connectionPoolSettings);
            return this;
        }

        public Builder stickySessionConfig(StickySessionConfig stickySessionConfig) {
            this.stickySessionConfig = Objects.requireNonNull(stickySessionConfig);
            return this;
        }

        public Builder healthCheckConfig(HealthCheckConfig healthCheckConfig) {
            this.healthCheckConfig = healthCheckConfig;
            return this;
        }

        public BackendService build() {
            return new BackendService(this);
        }
    }

    public static enum Protocol {
        HTTP,
        HTTPS;

    }
}

