/*
 * Decompiled with CFR 0.152.
 */
package com.hotels.styx.api.extension.service;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import java.util.Optional;
import java.util.concurrent.TimeUnit;

public class StickySessionConfig {
    private static final int TWELVE_HOURS = (int)TimeUnit.HOURS.toSeconds(12L);
    private final boolean enabled;
    private final int timeoutSeconds;

    private StickySessionConfig() {
        this(false, TWELVE_HOURS);
    }

    private StickySessionConfig(boolean enabled, Integer timeoutSeconds) {
        this.enabled = enabled;
        this.timeoutSeconds = Optional.ofNullable(timeoutSeconds).orElse(TWELVE_HOURS);
    }

    private StickySessionConfig(Builder builder) {
        this(builder.enabled, builder.timeoutSeconds);
    }

    public static StickySessionConfig stickySessionDisabled() {
        return new StickySessionConfig();
    }

    public static Builder newStickySessionConfigBuilder() {
        return new Builder();
    }

    public boolean stickySessionEnabled() {
        return this.enabled;
    }

    public int stickySessionTimeoutSeconds() {
        return this.timeoutSeconds;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("enabled", this.enabled).add("timeoutSeconds", this.timeoutSeconds).toString();
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.enabled, this.timeoutSeconds});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        StickySessionConfig that = (StickySessionConfig)obj;
        return this.enabled == that.enabled && this.timeoutSeconds == that.timeoutSeconds;
    }

    static /* synthetic */ int access$200() {
        return TWELVE_HOURS;
    }

    public static final class Builder {
        private boolean enabled;
        private int timeoutSeconds = StickySessionConfig.access$200();

        public Builder enabled(boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        public Builder timeout(int timeout, TimeUnit timeUnit) {
            this.timeoutSeconds = (int)timeUnit.toSeconds(timeout);
            return this;
        }

        public StickySessionConfig build() {
            return new StickySessionConfig(this);
        }
    }
}

