/*
 * Decompiled with CFR 0.152.
 */
package com.hotels.styx.api;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Strings;
import com.google.common.base.Throwables;
import com.hotels.styx.api.UrlQuery;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public final class Url
implements Comparable<Url> {
    private final String scheme;
    private final Optional<Authority> authority;
    private final String path;
    private final String fragment;
    private final Optional<UrlQuery> query;

    private Url(Builder builder) {
        this.scheme = builder.scheme;
        this.authority = builder.authority;
        this.path = builder.path;
        this.query = Optional.ofNullable(builder.queryBuilder).map(UrlQuery.Builder::build);
        this.fragment = builder.fragment;
    }

    public String scheme() {
        return this.scheme != null ? this.scheme : "";
    }

    public String path() {
        return this.path;
    }

    public Optional<String> fragment() {
        return Optional.ofNullable(this.fragment);
    }

    public Optional<Authority> authority() {
        return this.authority;
    }

    public Optional<String> host() {
        return this.authority.map(Authority::host);
    }

    public boolean isSecure() {
        return "https".equals(this.scheme);
    }

    public boolean isFullyQualified() {
        Optional<String> host = this.host();
        return host.isPresent() && !Strings.isNullOrEmpty((String)host.get());
    }

    public boolean isAbsolute() {
        return Objects.nonNull(this.scheme) && !this.scheme.isEmpty();
    }

    public boolean isRelative() {
        return this.scheme == null || this.scheme.isEmpty();
    }

    public URL toURL() {
        try {
            return this.toURI().toURL();
        }
        catch (MalformedURLException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    public URI toURI() {
        try {
            return new URI(this.toString());
        }
        catch (URISyntaxException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    @VisibleForTesting
    Optional<UrlQuery> query() {
        return this.query;
    }

    public Optional<String> queryParam(String name) {
        return this.query.flatMap(query -> query.parameterValue(name));
    }

    public Iterable<String> queryParams(String name) {
        return this.query.map(query -> query.parameterValues(name)).orElse(Collections.emptyList());
    }

    public Map<String, List<String>> queryParams() {
        if (!this.query.isPresent()) {
            return Collections.emptyMap();
        }
        HashMap<String, List<String>> map = new HashMap<String, List<String>>();
        this.query.get().parameters().forEach(parameter -> {
            List values = map.computeIfAbsent(parameter.key(), k -> new ArrayList());
            values.add(parameter.value());
        });
        return map;
    }

    public Iterable<String> queryParamNames() {
        return this.query.map(UrlQuery::parameterNames).orElse(Collections.emptySet());
    }

    public String encodedUri() {
        return this.toString();
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        if (this.authority.isPresent()) {
            if (this.scheme != null) {
                builder.append(this.scheme).append(":");
            }
            builder.append("//").append(this.authority.get());
        }
        builder.append(this.path);
        this.query.ifPresent(query -> builder.append("?").append(query.encodedQuery()));
        if (this.fragment != null) {
            builder.append("#").append(this.fragment);
        }
        return builder.toString();
    }

    @Override
    public int compareTo(Url other) {
        return this.toString().compareTo(other.toString());
    }

    public int hashCode() {
        return Objects.hash(this.scheme, this.authority, this.path, this.query, this.fragment);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Url other = (Url)obj;
        return Objects.equals(this.scheme, other.scheme) && Objects.equals(this.authority, other.authority) && Objects.equals(this.path, other.path) && Objects.equals(this.query, other.query) && Objects.equals(this.fragment, other.fragment);
    }

    public Builder newBuilder() {
        return new Builder(this);
    }

    public static final class Builder {
        private String scheme;
        private Optional<Authority> authority = Optional.empty();
        private String path = "";
        private String fragment;
        private UrlQuery.Builder queryBuilder;

        public Builder() {
        }

        public Builder(Url url) {
            this.scheme = url.scheme;
            this.authority = url.authority;
            this.path = url.path;
            this.queryBuilder = url.query.map(UrlQuery::newBuilder).orElse(null);
            this.fragment = url.fragment;
        }

        public static Builder url(String value) {
            URI uri = URI.create(value);
            return new Builder().scheme(uri.getScheme()).authority(uri.getAuthority()).path(uri.getRawPath()).rawQuery(uri.getRawQuery()).fragment(uri.getFragment());
        }

        public Builder rawQuery(String rawQuery) {
            this.queryBuilder = rawQuery == null ? null : new UrlQuery.Builder(rawQuery);
            return this;
        }

        public Builder scheme(String scheme) {
            this.scheme = scheme;
            return this;
        }

        public Builder authority(String authority) {
            this.authority = Authority.authority(authority);
            return this;
        }

        public Builder path(String path) {
            this.path = path;
            return this;
        }

        public Builder addQueryParam(String name, String value) {
            if (this.queryBuilder == null) {
                this.queryBuilder = new UrlQuery.Builder();
            }
            this.queryBuilder.addParam(name, value);
            return this;
        }

        public Builder fragment(String fragment) {
            this.fragment = fragment;
            return this;
        }

        public Builder authority(Authority authority) {
            this.authority = Optional.of(authority);
            return this;
        }

        public Builder dropHost() {
            if (this.authority.isPresent()) {
                this.authority = Optional.empty();
            }
            return this;
        }

        public Url build() {
            return new Url(this);
        }
    }

    public static final class Authority {
        private static final Pattern AUTHORITY = Pattern.compile("(?:([^@]+)@)?([^:]+)(?:\\:([\\d]+))?");
        private final String userInfo;
        private final String host;
        private final int port;

        private Authority(String userInfo, String host, int port) {
            this.userInfo = userInfo;
            this.host = host;
            this.port = port;
        }

        static Optional<Authority> authority(String authority) {
            Matcher matcher;
            if (authority != null && (matcher = AUTHORITY.matcher(authority)).matches()) {
                return Optional.of(Authority.authority(matcher.group(1), matcher.group(2), matcher.group(3)));
            }
            return Optional.empty();
        }

        static Authority authority(String userInfo, String host, String port) {
            return Authority.authority(userInfo, host, port == null ? -1 : Integer.parseInt(port));
        }

        static Authority authority(String host, int port) {
            return Authority.authority(null, host, port);
        }

        static Authority authority(String userInfo, String host, int port) {
            return new Authority(userInfo, host, port);
        }

        public String userInfo() {
            return this.userInfo;
        }

        public String host() {
            return this.host;
        }

        Authority host(String value) {
            return Authority.authority(this.userInfo, value, this.port);
        }

        public int port() {
            return this.port;
        }

        public String hostAndPort() {
            if (this.port >= 0) {
                return this.host + ":" + this.port;
            }
            return this.host;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            if (Strings.isNullOrEmpty((String)this.host)) {
                return builder.toString();
            }
            if (!Strings.isNullOrEmpty((String)this.userInfo)) {
                builder.append(this.userInfo).append("@");
            }
            builder.append(this.host);
            if (this.port != -1) {
                builder.append(":").append(this.port);
            }
            return builder.toString();
        }

        public int hashCode() {
            return Objects.hash(this.userInfo, this.host, this.port);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            Authority other = (Authority)obj;
            return Objects.equals(this.userInfo, other.userInfo) && Objects.equals(this.host, other.host) && Objects.equals(this.port, other.port);
        }
    }
}

