/*
 * Decompiled with CFR 0.152.
 */
package com.hotels.styx.api.extension.service;

import java.util.Objects;
import java.util.concurrent.TimeUnit;

public class ConnectionPoolSettings {
    public static final int DEFAULT_MAX_CONNECTIONS_PER_HOST = 50;
    public static final int DEFAULT_MAX_PENDING_CONNECTIONS_PER_HOST = 25;
    public static final int DEFAULT_CONNECT_TIMEOUT_MILLIS = 2000;
    public static final int DEFAULT_SOCKET_TIMEOUT_MILLIS = 11000;
    public static final long DEFAULT_CONNECTION_EXPIRATION_SECONDS = -1L;
    private final int maxConnectionsPerHost;
    private final int maxPendingConnectionsPerHost;
    private final int connectTimeoutMillis;
    private final int socketTimeoutMillis;
    private final int pendingConnectionTimeoutMillis;
    private final long connectionExpirationSeconds;

    ConnectionPoolSettings(Integer maxConnectionsPerHost, Integer maxPendingConnectionsPerHost, Integer connectTimeoutMillis, @Deprecated Integer socketTimeoutMillis, Integer pendingConnectionTimeoutMillis, Long connectionExpirationSeconds) {
        this.maxConnectionsPerHost = (Integer)com.google.common.base.Objects.firstNonNull((Object)maxConnectionsPerHost, (Object)50);
        this.maxPendingConnectionsPerHost = (Integer)com.google.common.base.Objects.firstNonNull((Object)maxPendingConnectionsPerHost, (Object)25);
        this.connectTimeoutMillis = (Integer)com.google.common.base.Objects.firstNonNull((Object)connectTimeoutMillis, (Object)2000);
        this.socketTimeoutMillis = (Integer)com.google.common.base.Objects.firstNonNull((Object)socketTimeoutMillis, (Object)11000);
        this.pendingConnectionTimeoutMillis = (Integer)com.google.common.base.Objects.firstNonNull((Object)pendingConnectionTimeoutMillis, (Object)2000);
        this.connectionExpirationSeconds = (Long)com.google.common.base.Objects.firstNonNull((Object)connectionExpirationSeconds, (Object)-1L);
    }

    @Deprecated
    public ConnectionPoolSettings(int maxConnectionsPerHost, int maxPendingConnectionsPerHost, int connectTimeoutMillis, int socketTimeoutMillis, int pendingConnectionTimeoutMillis, long connectionExpirationSeconds) {
        this.maxConnectionsPerHost = (Integer)com.google.common.base.Objects.firstNonNull((Object)maxConnectionsPerHost, (Object)50);
        this.maxPendingConnectionsPerHost = (Integer)com.google.common.base.Objects.firstNonNull((Object)maxPendingConnectionsPerHost, (Object)25);
        this.connectTimeoutMillis = (Integer)com.google.common.base.Objects.firstNonNull((Object)connectTimeoutMillis, (Object)2000);
        this.socketTimeoutMillis = (Integer)com.google.common.base.Objects.firstNonNull((Object)socketTimeoutMillis, (Object)11000);
        this.pendingConnectionTimeoutMillis = (Integer)com.google.common.base.Objects.firstNonNull((Object)pendingConnectionTimeoutMillis, (Object)2000);
        this.connectionExpirationSeconds = (Long)com.google.common.base.Objects.firstNonNull((Object)connectionExpirationSeconds, (Object)-1L);
    }

    public ConnectionPoolSettings(int maxConnectionsPerHost, int maxPendingConnectionsPerHost, int connectTimeoutMillis, int pendingConnectionTimeoutMillis, long connectionExpirationSeconds) {
        this(maxConnectionsPerHost, maxPendingConnectionsPerHost, connectTimeoutMillis, 11000, pendingConnectionTimeoutMillis, connectionExpirationSeconds);
    }

    private ConnectionPoolSettings(Builder builder) {
        this(builder.maxConnectionsPerHost, builder.maxPendingConnectionsPerHost, builder.connectTimeoutMillis, builder.socketTimeoutMillis, builder.pendingConnectionTimeoutMillis, builder.connectionExpirationSeconds);
    }

    public static ConnectionPoolSettings defaultConnectionPoolSettings() {
        return new ConnectionPoolSettings(new Builder());
    }

    @Deprecated
    public int socketTimeoutMillis() {
        return this.socketTimeoutMillis;
    }

    public int connectTimeoutMillis() {
        return this.connectTimeoutMillis;
    }

    public int maxConnectionsPerHost() {
        return this.maxConnectionsPerHost;
    }

    public int maxPendingConnectionsPerHost() {
        return this.maxPendingConnectionsPerHost;
    }

    public int pendingConnectionTimeoutMillis() {
        return this.pendingConnectionTimeoutMillis;
    }

    public long connectionExpirationSeconds() {
        return this.connectionExpirationSeconds;
    }

    public int hashCode() {
        return Objects.hash(this.maxConnectionsPerHost, this.maxPendingConnectionsPerHost, this.connectTimeoutMillis, this.socketTimeoutMillis, this.pendingConnectionTimeoutMillis);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ConnectionPoolSettings other = (ConnectionPoolSettings)obj;
        return Objects.equals(this.maxConnectionsPerHost, other.maxConnectionsPerHost) && Objects.equals(this.maxPendingConnectionsPerHost, other.maxPendingConnectionsPerHost) && Objects.equals(this.connectTimeoutMillis, other.connectTimeoutMillis) && Objects.equals(this.socketTimeoutMillis, other.socketTimeoutMillis) && Objects.equals(this.pendingConnectionTimeoutMillis, other.pendingConnectionTimeoutMillis);
    }

    public String toString() {
        return com.google.common.base.Objects.toStringHelper((Object)this).add("maxConnectionsPerHost", this.maxConnectionsPerHost).add("maxPendingConnectionsPerHost", this.maxPendingConnectionsPerHost).add("connectTimeoutMillis", this.connectTimeoutMillis).add("socketTimeoutMillis", this.socketTimeoutMillis).add("pendingConnectionTimeoutMillis", this.pendingConnectionTimeoutMillis).toString();
    }

    public static final class Builder {
        private int maxConnectionsPerHost = 50;
        private int maxPendingConnectionsPerHost = 25;
        private int connectTimeoutMillis = 2000;
        private int socketTimeoutMillis = 11000;
        private int pendingConnectionTimeoutMillis = 2000;
        private long connectionExpirationSeconds = -1L;

        public Builder() {
        }

        public Builder(ConnectionPoolSettings settings) {
            this.maxConnectionsPerHost = settings.maxConnectionsPerHost();
            this.maxPendingConnectionsPerHost = settings.maxPendingConnectionsPerHost();
            this.connectTimeoutMillis = settings.connectTimeoutMillis();
            this.socketTimeoutMillis = settings.socketTimeoutMillis();
            this.pendingConnectionTimeoutMillis = settings.pendingConnectionTimeoutMillis();
            this.connectionExpirationSeconds = settings.connectionExpirationSeconds();
        }

        public Builder maxConnectionsPerHost(int maxConnectionsPerHost) {
            this.maxConnectionsPerHost = maxConnectionsPerHost;
            return this;
        }

        public Builder maxPendingConnectionsPerHost(int maxPendingConnectionsPerHost) {
            this.maxPendingConnectionsPerHost = maxPendingConnectionsPerHost;
            return this;
        }

        @Deprecated
        public Builder socketTimeout(int socketTimeout, TimeUnit timeUnit) {
            this.socketTimeoutMillis = (int)timeUnit.toMillis(socketTimeout);
            return this;
        }

        public Builder connectTimeout(int connectTimeout, TimeUnit timeUnit) {
            this.connectTimeoutMillis = (int)timeUnit.toMillis(connectTimeout);
            return this;
        }

        public Builder pendingConnectionTimeout(int waitTimeout, TimeUnit timeUnit) {
            this.pendingConnectionTimeoutMillis = (int)timeUnit.toMillis(waitTimeout);
            return this;
        }

        public Builder connectionExpirationSeconds(long connectionExpirationSeconds) {
            this.connectionExpirationSeconds = connectionExpirationSeconds;
            return this;
        }

        public ConnectionPoolSettings build() {
            return new ConnectionPoolSettings(this);
        }
    }
}

