/*
 * Decompiled with CFR 0.152.
 */
package com.hotels.styx.api;

import com.hotels.styx.api.CookieUtil;
import com.hotels.styx.api.NettyCookie;
import io.netty.handler.codec.DateFormatter;
import io.netty.util.internal.ObjectUtil;
import java.nio.CharBuffer;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class ClientCookieDecoder {
    private static final Logger logger = LoggerFactory.getLogger(ClientCookieDecoder.class);
    static final ClientCookieDecoder STRICT = new ClientCookieDecoder(true);
    static final ClientCookieDecoder LAX = new ClientCookieDecoder(false);
    private final boolean strict;

    private ClientCookieDecoder(boolean strict) {
        this.strict = strict;
    }

    NettyCookie decode(String header) {
        char c;
        int headerLen = ((String)ObjectUtil.checkNotNull((Object)header, (String)"header")).length();
        if (headerLen == 0) {
            return null;
        }
        CookieBuilder cookieBuilder = null;
        int i = 0;
        while (i != headerLen && (c = header.charAt(i)) != ',') {
            int valueBegin;
            int valueEnd;
            int nameEnd;
            int nameBegin;
            block23: {
                if (c == '\t' || c == '\n' || c == '\u000b' || c == '\f' || c == '\r' || c == ' ' || c == ';') {
                    ++i;
                    continue;
                }
                nameBegin = i;
                do {
                    char curChar;
                    if ((curChar = header.charAt(i)) == ';') {
                        nameEnd = i;
                        valueEnd = -1;
                        valueBegin = -1;
                    } else {
                        if (curChar != '=') continue;
                        nameEnd = i++;
                        if (i == headerLen) {
                            valueEnd = 0;
                            valueBegin = 0;
                        } else {
                            valueBegin = i;
                            int semiPos = header.indexOf(59, i);
                            i = semiPos > 0 ? semiPos : headerLen;
                            valueEnd = i;
                        }
                    }
                    break block23;
                } while (++i != headerLen);
                nameEnd = headerLen;
                valueEnd = -1;
                valueBegin = -1;
            }
            if (valueEnd > 0 && header.charAt(valueEnd - 1) == ',') {
                --valueEnd;
            }
            if (cookieBuilder == null) {
                NettyCookie cookie = this.initCookie(header, nameBegin, nameEnd, valueBegin, valueEnd);
                if (nameBegin == -1 || nameBegin == nameEnd) {
                    logger.debug("Skipping cookie with null name");
                } else if (valueBegin == -1) {
                    logger.debug("Skipping cookie with null value");
                } else {
                    CharBuffer wrappedValue = CharBuffer.wrap(header, valueBegin, valueEnd);
                    CharSequence unwrappedValue = CookieUtil.unwrapValue(wrappedValue);
                    if (unwrappedValue == null) {
                        logger.debug("Skipping cookie because starting quotes are not properly balanced in '{}'", (Object)wrappedValue);
                    } else {
                        int invalidOctetPos;
                        String name = header.substring(nameBegin, nameEnd);
                        if (this.strict && (invalidOctetPos = CookieUtil.firstInvalidCookieNameOctet(name)) >= 0) {
                            if (logger.isDebugEnabled()) {
                                logger.debug("Skipping cookie because name '{}' contains invalid char '{}'", (Object)name, (Object)Character.valueOf(name.charAt(invalidOctetPos)));
                            }
                        } else {
                            boolean wrap;
                            boolean bl = wrap = unwrappedValue.length() != valueEnd - valueBegin;
                            if (this.strict && (invalidOctetPos = CookieUtil.firstInvalidCookieValueOctet(unwrappedValue)) >= 0) {
                                if (logger.isDebugEnabled()) {
                                    logger.debug("Skipping cookie because value '{}' contains invalid char '{}'", (Object)unwrappedValue, (Object)Character.valueOf(unwrappedValue.charAt(invalidOctetPos)));
                                }
                            } else {
                                NettyCookie cookie1 = new NettyCookie(name, unwrappedValue.toString());
                                cookie1.setWrap(wrap);
                                cookie = cookie1;
                            }
                        }
                    }
                }
                if (cookie == null) {
                    return null;
                }
                cookieBuilder = new CookieBuilder(cookie, header);
                continue;
            }
            cookieBuilder.appendAttribute(nameBegin, nameEnd, valueBegin, valueEnd);
        }
        return cookieBuilder != null ? cookieBuilder.cookie() : null;
    }

    protected NettyCookie initCookie(String header, int nameBegin, int nameEnd, int valueBegin, int valueEnd) {
        boolean wrap;
        int invalidOctetPos;
        if (nameBegin == -1 || nameBegin == nameEnd) {
            logger.debug("Skipping cookie with null name");
            return null;
        }
        if (valueBegin == -1) {
            logger.debug("Skipping cookie with null value");
            return null;
        }
        CharBuffer wrappedValue = CharBuffer.wrap(header, valueBegin, valueEnd);
        CharSequence unwrappedValue = CookieUtil.unwrapValue(wrappedValue);
        if (unwrappedValue == null) {
            logger.debug("Skipping cookie because starting quotes are not properly balanced in '{}'", (Object)wrappedValue);
            return null;
        }
        String name = header.substring(nameBegin, nameEnd);
        if (this.strict && (invalidOctetPos = CookieUtil.firstInvalidCookieNameOctet(name)) >= 0) {
            if (logger.isDebugEnabled()) {
                logger.debug("Skipping cookie because name '{}' contains invalid char '{}'", (Object)name, (Object)Character.valueOf(name.charAt(invalidOctetPos)));
            }
            return null;
        }
        boolean bl = wrap = unwrappedValue.length() != valueEnd - valueBegin;
        if (this.strict && (invalidOctetPos = CookieUtil.firstInvalidCookieValueOctet(unwrappedValue)) >= 0) {
            if (logger.isDebugEnabled()) {
                logger.debug("Skipping cookie because value '{}' contains invalid char '{}'", (Object)unwrappedValue, (Object)Character.valueOf(unwrappedValue.charAt(invalidOctetPos)));
            }
            return null;
        }
        NettyCookie cookie = new NettyCookie(name, unwrappedValue.toString());
        cookie.setWrap(wrap);
        return cookie;
    }

    private static class CookieBuilder {
        private final String header;
        private final NettyCookie cookie;
        private String domain;
        private String path;
        private long maxAge = Long.MIN_VALUE;
        private int expiresStart;
        private int expiresEnd;
        private boolean secure;
        private boolean httpOnly;
        private String sameSite;

        CookieBuilder(NettyCookie cookie, String header) {
            this.cookie = cookie;
            this.header = header;
        }

        private long mergeMaxAgeAndExpires() {
            Date expiresDate;
            if (this.maxAge != Long.MIN_VALUE) {
                return this.maxAge;
            }
            if (CookieBuilder.isValueDefined(this.expiresStart, this.expiresEnd) && (expiresDate = DateFormatter.parseHttpDate((CharSequence)this.header, (int)this.expiresStart, (int)this.expiresEnd)) != null) {
                long maxAgeMillis = expiresDate.getTime() - System.currentTimeMillis();
                return maxAgeMillis / 1000L + (long)(maxAgeMillis % 1000L != 0L ? 1 : 0);
            }
            return Long.MIN_VALUE;
        }

        NettyCookie cookie() {
            this.cookie.setDomain(this.domain);
            this.cookie.setPath(this.path);
            this.cookie.setMaxAge(this.mergeMaxAgeAndExpires());
            this.cookie.setSecure(this.secure);
            this.cookie.setHttpOnly(this.httpOnly);
            this.cookie.setSameSite(this.sameSite);
            return this.cookie;
        }

        void appendAttribute(int keyStart, int keyEnd, int valueStart, int valueEnd) {
            int length = keyEnd - keyStart;
            if (length == 4) {
                this.parse4(keyStart, valueStart, valueEnd);
            } else if (length == 6) {
                this.parse6(keyStart, valueStart, valueEnd);
            } else if (length == 7) {
                this.parse7(keyStart, valueStart, valueEnd);
            } else if (length == 8) {
                this.parse8(keyStart, valueStart, valueEnd);
            }
        }

        private void parse4(int nameStart, int valueStart, int valueEnd) {
            if (this.header.regionMatches(true, nameStart, "Path", 0, 4)) {
                this.path = this.computeValue(valueStart, valueEnd);
            }
        }

        private void parse6(int nameStart, int valueStart, int valueEnd) {
            if (this.header.regionMatches(true, nameStart, "Domain", 0, 5)) {
                this.domain = this.computeValue(valueStart, valueEnd);
            } else if (this.header.regionMatches(true, nameStart, "Secure", 0, 5)) {
                this.secure = true;
            }
        }

        private void setMaxAge(String value) {
            try {
                this.maxAge = Math.max(Long.parseLong(value), 0L);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }

        private void parse7(int nameStart, int valueStart, int valueEnd) {
            if (this.header.regionMatches(true, nameStart, "Expires", 0, 7)) {
                this.expiresStart = valueStart;
                this.expiresEnd = valueEnd;
            } else if (this.header.regionMatches(true, nameStart, "Max-Age", 0, 7)) {
                this.setMaxAge(this.computeValue(valueStart, valueEnd));
            }
        }

        private void parse8(int nameStart, int valueStart, int valueEnd) {
            if (this.header.regionMatches(true, nameStart, "HTTPOnly", 0, 8)) {
                this.httpOnly = true;
            } else if (this.header.regionMatches(true, nameStart, "SameSite", 0, 8)) {
                this.sameSite = this.computeValue(valueStart, valueEnd);
            }
        }

        private static boolean isValueDefined(int valueStart, int valueEnd) {
            return valueStart != -1 && valueStart != valueEnd;
        }

        private String computeValue(int valueStart, int valueEnd) {
            return CookieBuilder.isValueDefined(valueStart, valueEnd) ? this.header.substring(valueStart, valueEnd) : null;
        }
    }
}

