/*
 * Decompiled with CFR 0.152.
 */
package com.hotels.styx.api;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public final class HttpHeader {
    private final String name;
    private final List<String> values;

    public static HttpHeader header(String name, String ... values) {
        if (values.length <= 0) {
            throw new IllegalArgumentException("must give at least one value");
        }
        return new HttpHeader(Objects.requireNonNull(name), (List<String>)ImmutableList.copyOf((Object[])values));
    }

    private HttpHeader(String name, List<String> values) {
        this.name = name;
        this.values = values;
    }

    public String name() {
        return this.name;
    }

    public String value() {
        return this.values.get(0);
    }

    public Iterable<String> values() {
        return this.values;
    }

    public int hashCode() {
        return Objects.hash(this.name, this.values);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HttpHeader that = (HttpHeader)o;
        return Objects.equals(this.name, that.name) && Objects.equals(this.values, that.values);
    }

    public String toString() {
        return this.name + "=" + this.values.stream().filter(Objects::nonNull).collect(Collectors.joining(", "));
    }
}

