/*
 * Decompiled with CFR 0.152.
 */
package com.hotels.styx.api;

import com.hotels.styx.api.HttpHeaderNames;
import com.hotels.styx.api.HttpHeaders;
import com.hotels.styx.api.HttpMessageSupport;
import com.hotels.styx.api.HttpVersion;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Optional;

interface HttpMessage {
    public HttpVersion version();

    public HttpHeaders headers();

    public byte[] body();

    public String bodyAs(Charset var1);

    default public Optional<String> header(CharSequence name) {
        return this.headers().get(name);
    }

    default public List<String> headers(CharSequence name) {
        return this.headers().getAll(name);
    }

    default public Optional<Long> contentLength() {
        return this.header(HttpHeaderNames.CONTENT_LENGTH).map(Long::valueOf);
    }

    default public Optional<String> contentType() {
        return this.header(HttpHeaderNames.CONTENT_TYPE);
    }

    default public boolean chunked() {
        return HttpMessageSupport.chunked(this.headers());
    }
}

