/*
 * Decompiled with CFR 0.152.
 */
package com.hotels.styx.api;

import com.google.common.collect.ImmutableSet;
import com.hotels.styx.api.Buffer;
import com.hotels.styx.api.ByteStream;
import com.hotels.styx.api.Eventual;
import com.hotels.styx.api.HttpHeaderNames;
import com.hotels.styx.api.HttpHeaderValues;
import com.hotels.styx.api.HttpHeaders;
import com.hotels.styx.api.HttpResponse;
import com.hotels.styx.api.HttpResponseStatus;
import com.hotels.styx.api.HttpVersion;
import com.hotels.styx.api.LiveHttpMessage;
import com.hotels.styx.api.ResponseCookie;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;

public class LiveHttpResponse
implements LiveHttpMessage {
    private final HttpVersion version;
    private final HttpResponseStatus status;
    private final HttpHeaders headers;
    private final ByteStream body;

    LiveHttpResponse(Builder builder) {
        this.version = builder.version;
        this.status = builder.status;
        this.headers = builder.headers.build();
        this.body = builder.body;
    }

    public static Builder response() {
        return new Builder();
    }

    public static Builder response(HttpResponseStatus status) {
        return new Builder(status);
    }

    public static Builder response(HttpResponseStatus status, ByteStream body) {
        return new Builder(status).body(body);
    }

    @Override
    public HttpHeaders headers() {
        return this.headers;
    }

    @Override
    public ByteStream body() {
        return this.body;
    }

    @Override
    public HttpVersion version() {
        return this.version;
    }

    public Transformer newBuilder() {
        return new Transformer(this);
    }

    public HttpResponseStatus status() {
        return this.status;
    }

    public boolean isRedirect() {
        return this.status.code() >= 300 && this.status.code() < 400;
    }

    public Eventual<HttpResponse> aggregate(int maxContentBytes) {
        return Eventual.from(this.body.aggregate(maxContentBytes)).map(it -> new HttpResponse.Builder(this, LiveHttpResponse.decodeAndRelease(it)).disableValidation().build());
    }

    private static byte[] decodeAndRelease(Buffer aggregate) {
        try {
            byte[] byArray = ByteBufUtil.getBytes((ByteBuf)aggregate.delegate());
            return byArray;
        }
        finally {
            aggregate.delegate().release();
        }
    }

    public Set<ResponseCookie> cookies() {
        return ResponseCookie.decode(this.headers.getAll(HttpHeaderNames.SET_COOKIE));
    }

    public Optional<ResponseCookie> cookie(String name) {
        return this.cookies().stream().filter(cookie -> cookie.name().equals(name)).findFirst();
    }

    public String toString() {
        return "{version=" + this.version + ", status=" + this.status + "}";
    }

    public int hashCode() {
        return Objects.hash(this.version, this.status, this.headers);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        LiveHttpResponse other = (LiveHttpResponse)obj;
        return Objects.equals(this.version, other.version) && Objects.equals(this.status, other.status) && Objects.equals(this.headers, other.headers);
    }

    public static final class Builder
    implements BuilderTransformer {
        private HttpResponseStatus status = HttpResponseStatus.OK;
        private HttpHeaders.Builder headers;
        private HttpVersion version = HttpVersion.HTTP_1_1;
        private boolean validate = true;
        private ByteStream body;

        public Builder() {
            this.headers = new HttpHeaders.Builder();
            this.body = new ByteStream((Publisher<Buffer>)Flux.empty());
        }

        public Builder(HttpResponseStatus status) {
            this();
            this.status = status;
        }

        public Builder(LiveHttpResponse response) {
            this.status = response.status();
            this.version = response.version();
            this.headers = response.headers().newBuilder();
            this.body = response.body();
        }

        public Builder(HttpResponse response, ByteStream byteStream) {
            this.status = HttpResponseStatus.statusWithCode(response.status().code());
            this.version = HttpVersion.httpVersion(response.version().toString());
            this.headers = response.headers().newBuilder();
            this.body = Objects.requireNonNull(byteStream);
        }

        @Override
        public Builder status(HttpResponseStatus status) {
            this.status = status;
            return this;
        }

        public Builder body(ByteStream content) {
            this.body = Objects.requireNonNull(content);
            return this;
        }

        @Override
        public Builder version(HttpVersion version) {
            this.version = Objects.requireNonNull(version);
            return this;
        }

        @Override
        public Builder disableCaching() {
            this.header("Pragma", "no-cache");
            this.header("Expires", "Mon, 1 Jan 2007 08:00:00 GMT");
            this.header("Cache-Control", "no-cache,must-revalidate,no-store");
            return this;
        }

        @Override
        public Builder setChunked() {
            this.headers.add(HttpHeaderNames.TRANSFER_ENCODING, HttpHeaderValues.CHUNKED);
            this.headers.remove(HttpHeaderNames.CONTENT_LENGTH);
            return this;
        }

        @Override
        public Builder cookies(ResponseCookie ... cookies) {
            return this.cookies(Arrays.asList(cookies));
        }

        @Override
        public Builder cookies(Collection<ResponseCookie> cookies) {
            Objects.requireNonNull(cookies);
            this.headers.remove(HttpHeaderNames.SET_COOKIE);
            return this.addCookies((Collection)cookies);
        }

        @Override
        public Builder addCookies(ResponseCookie ... cookies) {
            return this.addCookies(Arrays.asList(cookies));
        }

        @Override
        public Builder addCookies(Collection<ResponseCookie> cookies) {
            Objects.requireNonNull(cookies);
            if (cookies.isEmpty()) {
                return this;
            }
            this.removeCookies((Collection)cookies.stream().map(ResponseCookie::name).collect(Collectors.toList()));
            ResponseCookie.encode(cookies).forEach(cookie -> this.addHeader(HttpHeaderNames.SET_COOKIE, cookie));
            return this;
        }

        @Override
        public Builder removeCookies(String ... names) {
            return this.removeCookies(Arrays.asList(names));
        }

        @Override
        public Builder removeCookies(Collection<String> names) {
            Objects.requireNonNull(names);
            if (names.isEmpty()) {
                return this;
            }
            return this.removeCookiesIf(Builder.toSet(names)::contains);
        }

        private Builder removeCookiesIf(Predicate<String> removeIfName) {
            Predicate<ResponseCookie> keepIf = cookie -> !removeIfName.test(cookie.name());
            List newCookies = ResponseCookie.decode(this.headers.getAll(HttpHeaderNames.SET_COOKIE)).stream().filter(keepIf).collect(Collectors.toList());
            return this.cookies((Collection)newCookies);
        }

        private static <T> Set<T> toSet(Collection<T> collection) {
            return collection instanceof Set ? (Set)collection : ImmutableSet.copyOf(collection);
        }

        @Override
        public Builder header(CharSequence name, Object value) {
            this.headers.set(name, value);
            return this;
        }

        @Override
        public Builder addHeader(CharSequence name, Object value) {
            this.headers.add(name, value);
            return this;
        }

        @Override
        public Builder removeHeader(CharSequence name) {
            this.headers.remove(name);
            return this;
        }

        @Override
        public Builder removeBody() {
            this.body = this.body.drop();
            return this;
        }

        @Override
        public Builder headers(HttpHeaders headers) {
            this.headers = headers.newBuilder();
            return this;
        }

        @Override
        public Builder disableValidation() {
            this.validate = false;
            return this;
        }

        @Override
        public LiveHttpResponse build() {
            if (this.validate) {
                this.ensureContentLengthIsValid();
            }
            return new LiveHttpResponse(this);
        }

        Builder ensureContentLengthIsValid() {
            List<String> contentLengths = this.headers.build().getAll(HttpHeaderNames.CONTENT_LENGTH);
            if (contentLengths.size() > 1) {
                throw new IllegalArgumentException(String.format("Duplicate Content-Length found. %s", contentLengths));
            }
            if (contentLengths.size() == 1 && !Builder.isNonNegativeInteger(contentLengths.get(0))) {
                throw new IllegalArgumentException(String.format("Invalid Content-Length found. %s", contentLengths.get(0)));
            }
            return this;
        }

        private static boolean isNonNegativeInteger(String contentLength) {
            try {
                long value = Long.parseLong(contentLength);
                return value >= 0L;
            }
            catch (NumberFormatException e) {
                return false;
            }
        }
    }

    public static final class Transformer
    implements BuilderTransformer {
        private final Builder builder;

        public Transformer(LiveHttpResponse response) {
            this.builder = new Builder(response);
        }

        public Transformer body(Function<ByteStream, ByteStream> transformation) {
            this.builder.body(Objects.requireNonNull(transformation.apply(this.builder.body)));
            return this;
        }

        @Override
        public Transformer status(HttpResponseStatus status) {
            this.builder.status(status);
            return this;
        }

        @Override
        public Transformer version(HttpVersion version) {
            this.builder.version(version);
            return this;
        }

        @Override
        public Transformer disableCaching() {
            this.builder.disableCaching();
            return this;
        }

        @Override
        public Transformer setChunked() {
            this.builder.setChunked();
            return this;
        }

        @Override
        public Transformer cookies(ResponseCookie ... cookies) {
            this.builder.cookies(cookies);
            return this;
        }

        @Override
        public Transformer cookies(Collection<ResponseCookie> cookies) {
            this.builder.cookies((Collection)cookies);
            return this;
        }

        @Override
        public Transformer addCookies(ResponseCookie ... cookies) {
            this.builder.addCookies(cookies);
            return this;
        }

        @Override
        public Transformer addCookies(Collection<ResponseCookie> cookies) {
            this.builder.addCookies((Collection)cookies);
            return this;
        }

        @Override
        public Transformer removeCookies(String ... names) {
            this.builder.removeCookies(names);
            return this;
        }

        @Override
        public Transformer removeCookies(Collection<String> names) {
            this.builder.removeCookies((Collection)names);
            return this;
        }

        @Override
        public Transformer header(CharSequence name, Object value) {
            this.builder.header(name, value);
            return this;
        }

        @Override
        public Transformer addHeader(CharSequence name, Object value) {
            this.builder.addHeader(name, value);
            return this;
        }

        @Override
        public Transformer removeHeader(CharSequence name) {
            this.builder.removeHeader(name);
            return this;
        }

        @Override
        public Transformer removeBody() {
            this.builder.removeBody();
            return this;
        }

        @Override
        public Transformer headers(HttpHeaders headers) {
            this.builder.headers(headers);
            return this;
        }

        @Override
        public Transformer disableValidation() {
            this.builder.disableValidation();
            return this;
        }

        @Override
        public LiveHttpResponse build() {
            return this.builder.build();
        }
    }

    private static interface BuilderTransformer {
        public BuilderTransformer status(HttpResponseStatus var1);

        public BuilderTransformer version(HttpVersion var1);

        public BuilderTransformer disableCaching();

        public BuilderTransformer setChunked();

        public BuilderTransformer cookies(ResponseCookie ... var1);

        public BuilderTransformer cookies(Collection<ResponseCookie> var1);

        public BuilderTransformer addCookies(ResponseCookie ... var1);

        public BuilderTransformer addCookies(Collection<ResponseCookie> var1);

        public BuilderTransformer removeCookies(String ... var1);

        public BuilderTransformer removeCookies(Collection<String> var1);

        public BuilderTransformer header(CharSequence var1, Object var2);

        public BuilderTransformer addHeader(CharSequence var1, Object var2);

        public BuilderTransformer removeHeader(CharSequence var1);

        public BuilderTransformer removeBody();

        public BuilderTransformer headers(HttpHeaders var1);

        public BuilderTransformer disableValidation();

        public LiveHttpResponse build();
    }
}

