/*
 * Decompiled with CFR 0.152.
 */
package com.hotels.styx.api;

import com.hotels.styx.api.ClientCookieDecoder;
import com.hotels.styx.api.NettyCookie;
import com.hotels.styx.api.ServerCookieEncoder;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

public final class ResponseCookie {
    private final String name;
    private final String value;
    private final String domain;
    private final Long maxAge;
    private final String path;
    private final boolean httpOnly;
    private final boolean secure;
    private final int hashCode;
    private final String sameSite;

    private ResponseCookie(Builder builder) {
        if (builder.name == null || builder.name.isEmpty()) {
            throw new IllegalArgumentException();
        }
        this.name = builder.name;
        this.value = builder.value;
        this.domain = builder.domain;
        this.maxAge = builder.maxAge;
        this.path = builder.path;
        this.httpOnly = builder.httpOnly;
        this.secure = builder.secure;
        this.sameSite = builder.sameSite;
        this.hashCode = Objects.hash(this.name, this.value, this.domain, this.maxAge, this.path, this.secure, this.httpOnly, this.sameSite);
    }

    public static Builder responseCookie(String name, String value) {
        return new Builder(name, value);
    }

    public static Set<ResponseCookie> decode(List<String> headerValues) {
        return headerValues.stream().map(ClientCookieDecoder.LAX::decode).filter(Objects::nonNull).map(ResponseCookie::convert).collect(Collectors.toSet());
    }

    public static List<String> encode(Collection<ResponseCookie> cookies) {
        Set nettyCookies = cookies.stream().map(ResponseCookie::convert).collect(Collectors.toSet());
        return ServerCookieEncoder.LAX.encode(nettyCookies);
    }

    public static String encode(ResponseCookie cookie) {
        return ServerCookieEncoder.LAX.encode(ResponseCookie.convert(cookie));
    }

    public String name() {
        return this.name;
    }

    public String value() {
        return this.value;
    }

    public Optional<Long> maxAge() {
        return Optional.ofNullable(this.maxAge).filter(value -> value != Long.MIN_VALUE);
    }

    public Optional<String> path() {
        return Optional.ofNullable(this.path);
    }

    public boolean httpOnly() {
        return this.httpOnly;
    }

    public Optional<String> domain() {
        return Optional.ofNullable(this.domain);
    }

    public boolean secure() {
        return this.secure;
    }

    public Optional<String> sameSite() {
        return Optional.ofNullable(this.sameSite);
    }

    private static NettyCookie convert(ResponseCookie cookie) {
        NettyCookie nCookie = new NettyCookie(cookie.name, cookie.value);
        nCookie.setDomain(cookie.domain);
        nCookie.setHttpOnly(cookie.httpOnly);
        nCookie.setSecure(cookie.secure);
        if (cookie.maxAge != null) {
            nCookie.setMaxAge(cookie.maxAge);
        }
        nCookie.setPath(cookie.path);
        nCookie.setSameSite(cookie.sameSite);
        return nCookie;
    }

    private static ResponseCookie convert(NettyCookie cookie) {
        String value = cookie.wrap() ? ResponseCookie.quote(cookie.value()) : cookie.value();
        return ResponseCookie.responseCookie(cookie.name(), value).domain(cookie.domain()).path(cookie.path()).maxAge(cookie.maxAge()).httpOnly(cookie.isHttpOnly()).secure(cookie.isSecure()).sameSiteRawValue(cookie.sameSite()).build();
    }

    private static String quote(String value) {
        return "\"" + value + "\"";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ResponseCookie that = (ResponseCookie)o;
        return this.httpOnly == that.httpOnly && this.secure == that.secure && Objects.equals(this.name, that.name) && Objects.equals(this.value, that.value) && Objects.equals(this.domain, that.domain) && Objects.equals(this.maxAge, that.maxAge) && Objects.equals(this.path, that.path) && Objects.equals(this.sameSite, that.sameSite);
    }

    public int hashCode() {
        return this.hashCode;
    }

    public String toString() {
        return "ResponseCookie{name='" + this.name + '\'' + ", value='" + this.value + '\'' + ", domain='" + this.domain + '\'' + ", maxAge=" + this.maxAge + ", path='" + this.path + '\'' + ", httpOnly=" + this.httpOnly + ", secure=" + this.secure + ", sameSite=" + this.sameSite + '}';
    }

    public static class Builder {
        private String name;
        private String value;
        private String domain;
        private Long maxAge;
        private String path;
        private boolean httpOnly;
        private boolean secure;
        private String sameSite;

        private Builder(String name, String value) {
            this.name = Objects.requireNonNull(name);
            this.value = Objects.requireNonNull(value);
        }

        public Builder name(String name) {
            this.name = Objects.requireNonNull(name);
            return this;
        }

        public Builder value(String value) {
            this.value = Objects.requireNonNull(value);
            return this;
        }

        public Builder domain(String domain) {
            this.domain = domain;
            return this;
        }

        public Builder maxAge(long maxAge) {
            this.maxAge = maxAge == Long.MIN_VALUE ? null : Long.valueOf(maxAge);
            return this;
        }

        public Builder path(String path) {
            this.path = path;
            return this;
        }

        public Builder httpOnly(boolean httpOnly) {
            this.httpOnly = httpOnly;
            return this;
        }

        public Builder secure(boolean secure) {
            this.secure = secure;
            return this;
        }

        public Builder sameSite(SameSite sameSite) {
            this.sameSite = sameSite.name();
            return this;
        }

        public Builder sameSiteRawValue(String sameSite) {
            this.sameSite = sameSite;
            return this;
        }

        public ResponseCookie build() {
            return new ResponseCookie(this);
        }
    }

    public static enum SameSite {
        Lax,
        Strict,
        None;

    }
}

