/*
 * Decompiled with CFR 0.152.
 */
package com.hotels.styx.api.configuration.converters;

import com.hotels.styx.api.configuration.ConversionException;
import com.hotels.styx.api.configuration.Converter;
import java.lang.reflect.Array;

public class SimpleConverter
implements Converter {
    @Override
    public <T> T convert(Object source, Class<T> targetType) {
        if (source == null) {
            return null;
        }
        if (targetType == Boolean.class || targetType == Boolean.TYPE) {
            Boolean t = Boolean.valueOf(source.toString());
            return (T)t;
        }
        Object t = this.parse(source.toString(), targetType);
        return (T)t;
    }

    private Object parse(String source, Class<?> targetType) throws AssertionError {
        if (targetType.isEnum()) {
            String vlow = source.toLowerCase();
            for (Enum e : targetType.asSubclass(Enum.class).getEnumConstants()) {
                if (!e.name().toLowerCase().equals(vlow)) continue;
                return e;
            }
            throw new ConversionException("Enum constant not found: " + source);
        }
        if (targetType == Double.class || targetType == Double.TYPE) {
            return Double.valueOf(source);
        }
        if (targetType == Integer.class || targetType == Integer.TYPE) {
            return Integer.valueOf(source);
        }
        if (targetType == String.class) {
            return source;
        }
        if (targetType.isArray()) {
            String[] strVals = source.split(",", -1);
            Class<?> arrayType = targetType.getComponentType();
            Object a = Array.newInstance(arrayType, strVals.length);
            for (int i = 0; i < strVals.length; ++i) {
                Array.set(a, i, this.parse(strVals[i], arrayType));
            }
            return a;
        }
        throw new ConversionException("Unknown return type " + targetType + " (val: " + source + ")");
    }
}

