/*
 * Decompiled with CFR 0.152.
 */
package com.hotels.styx.api.extension.service;

import java.net.URI;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.TimeUnit;

public final class HealthCheckConfig {
    public static final int DEFAULT_HEALTHY_THRESHOLD_VALUE = 2;
    public static final int DEFAULT_UNHEALTHY_THRESHOLD_VALUE = 2;
    public static final Long DEFAULT_HEALTH_CHECK_INTERVAL = 5000L;
    public static final Long DEFAULT_TIMEOUT_VALUE = 2000L;
    private final Optional<String> uri;
    private final long intervalMillis;
    private final long timeoutMillis;
    private final int healthyThreshold;
    private final int unhealthyThreshold;

    private HealthCheckConfig() {
        this(HealthCheckConfig.newHealthCheckConfigBuilder());
    }

    private HealthCheckConfig(Builder builder) {
        this(builder.uri, builder.intervalMillis, builder.timeoutMillis, builder.healthyThreshold, builder.unhealthyThreshold);
    }

    private HealthCheckConfig(Optional<String> uri, Optional<Long> intervalMillis, Optional<Long> timeoutMillis, Optional<Integer> healthyThreshold, Optional<Integer> unhealthyThreshold) {
        this.uri = uri.map(this::checkValidUri);
        this.intervalMillis = HealthCheckConfig.zeroToAbsent(intervalMillis).orElse(DEFAULT_HEALTH_CHECK_INTERVAL);
        this.timeoutMillis = HealthCheckConfig.zeroToAbsent(timeoutMillis).orElse(DEFAULT_TIMEOUT_VALUE);
        this.healthyThreshold = healthyThreshold.orElse(2);
        this.unhealthyThreshold = unhealthyThreshold.orElse(2);
        if (this.intervalMillis < 1L) {
            throw new IllegalArgumentException(String.format("intervalMillis [%s] cannot be < 1 ms", intervalMillis));
        }
        if (this.timeoutMillis < 1L) {
            throw new IllegalArgumentException(String.format("timeoutMillis [%s] cannot be < 1 ms", timeoutMillis));
        }
        if (this.healthyThreshold < 1) {
            throw new IllegalArgumentException(String.format("healthyThreshold [%s] cannot be < 1", healthyThreshold));
        }
        if (this.unhealthyThreshold < 1) {
            throw new IllegalArgumentException(String.format("unhealthyThreshold [%s] cannot be < 1", unhealthyThreshold));
        }
    }

    private String checkValidUri(String uri) {
        try {
            URI.create(uri);
            return uri;
        }
        catch (Throwable cause) {
            String message = String.format("Invalid health check URI. URI='%s'", uri);
            throw new IllegalArgumentException(message, cause);
        }
    }

    public static HealthCheckConfig noHealthCheck() {
        return new HealthCheckConfig();
    }

    private static Optional<Long> zeroToAbsent(Optional<Long> optional) {
        if (!optional.isPresent() || optional.get() == 0L) {
            return Optional.empty();
        }
        return optional;
    }

    public Optional<String> uri() {
        return this.uri;
    }

    String getUri() {
        return this.uri.orElse(null);
    }

    public long intervalMillis() {
        return this.intervalMillis;
    }

    public long timeoutMillis() {
        return this.timeoutMillis;
    }

    public int healthyThreshold() {
        return this.healthyThreshold;
    }

    public int unhealthyThreshold() {
        return this.unhealthyThreshold;
    }

    public boolean isEnabled() {
        return this.uri.isPresent();
    }

    public int hashCode() {
        return Objects.hash(this.uri, this.intervalMillis, this.timeoutMillis, this.healthyThreshold, this.unhealthyThreshold);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        HealthCheckConfig other = (HealthCheckConfig)obj;
        return Objects.equals(this.uri, other.uri) && Objects.equals(this.intervalMillis, other.intervalMillis) && Objects.equals(this.timeoutMillis, other.timeoutMillis) && Objects.equals(this.healthyThreshold, other.healthyThreshold) && Objects.equals(this.unhealthyThreshold, other.unhealthyThreshold);
    }

    public String toString() {
        return new StringBuilder(160).append(this.getClass().getSimpleName()).append("{uri=").append(this.uri).append(", intervalMillis=").append(this.intervalMillis).append(", timeoutMillis=").append(this.timeoutMillis).append(", healthyThreshold=").append(this.healthyThreshold).append(", unhealthyThreshold=").append(this.unhealthyThreshold).append('}').toString();
    }

    public static Builder newHealthCheckConfigBuilder() {
        return new Builder();
    }

    public static Builder newHealthCheckConfigBuilder(HealthCheckConfig healthCheckConfig) {
        return new Builder(healthCheckConfig);
    }

    public static final class Builder {
        private Optional<String> uri = Optional.empty();
        private Optional<Long> intervalMillis = Optional.empty();
        private Optional<Long> timeoutMillis = Optional.empty();
        private Optional<Integer> healthyThreshold = Optional.empty();
        private Optional<Integer> unhealthyThreshold = Optional.empty();

        private Builder() {
        }

        private Builder(HealthCheckConfig healthCheckConfig) {
            this.uri = healthCheckConfig.uri;
            this.intervalMillis = Optional.of(healthCheckConfig.intervalMillis);
            this.healthyThreshold = Optional.of(healthCheckConfig.healthyThreshold);
            this.unhealthyThreshold = Optional.of(healthCheckConfig.unhealthyThreshold);
        }

        public Builder uri(String uri) {
            return this.uri(Optional.ofNullable(uri));
        }

        public Builder uri(Optional<String> uri) {
            this.uri = Objects.requireNonNull(uri);
            return this;
        }

        public Builder interval(long interval) {
            return this.interval(interval, TimeUnit.MILLISECONDS);
        }

        public Builder interval(long interval, TimeUnit timeUnit) {
            this.intervalMillis = Optional.of(timeUnit.toMillis(interval));
            return this;
        }

        public Builder timeout(long timeout) {
            return this.timeout(timeout, TimeUnit.MILLISECONDS);
        }

        public Builder timeout(long timeout, TimeUnit timeUnit) {
            this.timeoutMillis = Optional.of(timeUnit.toMillis(timeout));
            return this;
        }

        public Builder healthyThreshold(int healthyThreshold) {
            this.healthyThreshold = Optional.of(healthyThreshold);
            return this;
        }

        public Builder unhealthyThreshold(int unhealthyThreshold) {
            this.unhealthyThreshold = Optional.of(unhealthyThreshold);
            return this;
        }

        public HealthCheckConfig build() {
            return new HealthCheckConfig(this);
        }
    }
}

