/*
 * Decompiled with CFR 0.152.
 */
package com.hotels.styx.api.extension.service;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Sets;
import com.hotels.styx.api.extension.service.Certificate;
import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;

public class TlsSettings {
    private static final String DEFAULT_TRUST_STORE_PATH = System.getProperty("java.home") + File.separator + "lib" + File.separator + "security" + File.separator + "cacerts";
    private static final String DEFAULT_SSL_PROVIDER = "JDK";
    private final boolean trustAllCerts;
    private final String sslProvider;
    private final Set<Certificate> additionalCerts;
    private final String trustStorePath;
    private final char[] trustStorePassword;
    private final List<String> protocols;
    private final List<String> cipherSuites;
    private final boolean sendSni;
    private final Optional<String> sniHost;

    private TlsSettings(Builder builder) {
        this.trustAllCerts = Objects.requireNonNull(builder.trustAllCerts);
        this.sslProvider = Objects.requireNonNull(builder.sslProvider);
        this.additionalCerts = builder.additionalCerts;
        this.trustStorePath = builder.trustStorePath;
        this.trustStorePassword = this.toCharArray(builder.trustStorePassword);
        this.protocols = ImmutableList.copyOf((Collection)builder.protocols);
        this.cipherSuites = ImmutableList.copyOf((Collection)builder.cipherSuites);
        this.sendSni = builder.sendSni;
        this.sniHost = Optional.ofNullable(builder.sniHost);
    }

    private char[] toCharArray(String password) {
        return password == null ? "".toCharArray() : password.toCharArray();
    }

    public boolean trustAllCerts() {
        return this.trustAllCerts;
    }

    public boolean authenticate() {
        return !this.trustAllCerts;
    }

    public String sslProvider() {
        return this.sslProvider;
    }

    public Set<Certificate> additionalCerts() {
        return this.additionalCerts;
    }

    public String trustStorePath() {
        return this.trustStorePath;
    }

    public char[] trustStorePassword() {
        return this.trustStorePassword;
    }

    public List<String> protocols() {
        return this.protocols;
    }

    public List<String> cipherSuites() {
        return this.cipherSuites;
    }

    public boolean sendSni() {
        return this.sendSni;
    }

    public Optional<String> sniHost() {
        return this.sniHost;
    }

    public String getSniHost() {
        return this.sniHost.orElse(null);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        TlsSettings other = (TlsSettings)obj;
        return Objects.equals(this.trustAllCerts, other.trustAllCerts) && Objects.equals(this.sslProvider, other.sslProvider) && Objects.equals(this.additionalCerts, other.additionalCerts) && Objects.equals(this.trustStorePath, other.trustStorePath) && Arrays.equals(this.trustStorePassword, other.trustStorePassword) && Objects.equals(this.protocols, other.protocols) && Objects.equals(this.cipherSuites, other.cipherSuites) && Objects.equals(this.sniHost, other.sniHost) && Objects.equals(this.sendSni, other.sendSni);
    }

    public String toString() {
        return new StringBuilder(288).append(this.getClass().getSimpleName()).append("{trustAllCerts=").append(this.trustAllCerts).append(", sslProvider=").append(this.sslProvider).append(", additionalCerts=").append(this.additionalCerts).append(", trustStorePath=").append(this.trustStorePath).append(", trustStorePassword=").append(this.trustStorePassword).append(", protocols=").append(this.protocols).append(", cipherSuites=").append(this.cipherSuites).append(", sendSni=").append(this.sendSni).append(", sniHost=").append(this.getSniHost()).append('}').toString();
    }

    public int hashCode() {
        return Objects.hash(this.trustAllCerts, this.sslProvider, this.additionalCerts, this.trustStorePath, Arrays.hashCode(this.trustStorePassword), this.protocols, this.cipherSuites, this.sendSni, this.getSniHost());
    }

    static /* synthetic */ String access$900() {
        return DEFAULT_TRUST_STORE_PATH;
    }

    public static final class Builder {
        private boolean trustAllCerts = true;
        private String sslProvider = "JDK";
        private Set<Certificate> additionalCerts = Collections.emptySet();
        private String trustStorePath = System.getProperty("javax.net.ssl.trustStore", TlsSettings.access$900());
        private String trustStorePassword = System.getProperty("javax.net.ssl.trustStorePassword");
        private List<String> protocols = Collections.emptyList();
        private List<String> cipherSuites = Collections.emptyList();
        private boolean sendSni = true;
        private String sniHost;

        @Deprecated
        public Builder trustAllCerts(boolean trustAllCerts) {
            this.trustAllCerts = trustAllCerts;
            return this;
        }

        public Builder authenticate(boolean authenticate) {
            this.trustAllCerts = !authenticate;
            return this;
        }

        public Builder sslProvider(String sslProvider) {
            this.sslProvider = sslProvider;
            return this;
        }

        public Builder additionalCerts(Certificate ... certificates) {
            this.additionalCerts = Sets.newHashSet((Object[])certificates);
            return this;
        }

        public Builder trustStorePath(String trustStorePath) {
            this.trustStorePath = trustStorePath;
            return this;
        }

        public Builder trustStorePassword(String trustStorePwd) {
            this.trustStorePassword = trustStorePwd;
            return this;
        }

        public Builder protocols(List<String> protocols) {
            this.protocols = protocols;
            return this;
        }

        public Builder cipherSuites(List<String> cipherSuites) {
            this.cipherSuites = cipherSuites;
            return this;
        }

        public Builder sendSni(boolean sendSni) {
            this.sendSni = sendSni;
            return this;
        }

        public Builder sniHost(String sniHost) {
            this.sniHost = sniHost;
            return this;
        }

        public TlsSettings build() {
            if (!this.trustAllCerts && this.trustStorePassword == null) {
                throw new IllegalArgumentException("trustStorePassword must be supplied when remote peer authentication is enabled.");
            }
            return new TlsSettings(this);
        }
    }
}

