/*
 * Decompiled with CFR 0.152.
 */
package com.hotels.styx.api.extension.service.spi;

import com.google.common.collect.ImmutableMap;
import com.hotels.styx.api.Eventual;
import com.hotels.styx.api.HttpHandler;
import com.hotels.styx.api.HttpHeaderNames;
import com.hotels.styx.api.HttpHeaderValues;
import com.hotels.styx.api.HttpResponse;
import com.hotels.styx.api.HttpResponseStatus;
import com.hotels.styx.api.extension.service.spi.ServiceFailureException;
import com.hotels.styx.api.extension.service.spi.StyxService;
import com.hotels.styx.api.extension.service.spi.StyxServiceStatus;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractStyxService
implements StyxService {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractStyxService.class);
    private final String name;
    private final AtomicReference<StyxServiceStatus> status = new AtomicReference<StyxServiceStatus>(StyxServiceStatus.CREATED);

    public AbstractStyxService(String name) {
        this.name = name;
        LOGGER.info("Created {}", (Object)name);
    }

    public StyxServiceStatus status() {
        return this.status.get();
    }

    protected CompletableFuture<Void> startService() {
        return CompletableFuture.completedFuture(null);
    }

    protected CompletableFuture<Void> stopService() {
        return CompletableFuture.completedFuture(null);
    }

    @Override
    public CompletableFuture<Void> start() {
        boolean changed = this.status.compareAndSet(StyxServiceStatus.CREATED, StyxServiceStatus.STARTING);
        LOGGER.info("Starting {}", (Object)this.name);
        if (changed) {
            return ((CompletableFuture)this.startService().exceptionally((Function)this.failWithMessage("Service failed to start."))).thenAccept(na -> {
                this.status.compareAndSet(StyxServiceStatus.STARTING, StyxServiceStatus.RUNNING);
                LOGGER.info("Started {}", (Object)this.name);
            });
        }
        throw new IllegalStateException(String.format("Start '%s' called in %s state", new Object[]{this.name, this.status.get()}));
    }

    @Override
    public CompletableFuture<Void> stop() {
        boolean changed = this.status.compareAndSet(StyxServiceStatus.RUNNING, StyxServiceStatus.STOPPING);
        LOGGER.info("Stopping {}", (Object)this.name);
        if (changed) {
            return ((CompletableFuture)this.stopService().exceptionally((Function)this.failWithMessage("Service failed to stop."))).thenAccept(na -> {
                this.status.compareAndSet(StyxServiceStatus.STOPPING, StyxServiceStatus.STOPPED);
                LOGGER.info("Stopped {}", (Object)this.name);
            });
        }
        throw new IllegalStateException(String.format("Service '%s' stopped in %s state", new Object[]{this.name, this.status.get()}));
    }

    private Function<Throwable, Void> failWithMessage(String message) {
        return cause -> {
            this.status.set(StyxServiceStatus.FAILED);
            throw new ServiceFailureException(message, (Throwable)cause);
        };
    }

    @Override
    public Map<String, HttpHandler> adminInterfaceHandlers() {
        return ImmutableMap.of((Object)"status", (request, context) -> Eventual.of(HttpResponse.response(HttpResponseStatus.OK).addHeader(HttpHeaderNames.CONTENT_TYPE, HttpHeaderValues.APPLICATION_JSON).body(String.format("{ name: \"%s\" status: \"%s\" }", this.name, this.status), StandardCharsets.UTF_8).build().stream()));
    }

    public String serviceName() {
        return this.name;
    }
}

